/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UploadProgressDialog
extends TaxmeProgressMonitorDialog {
    private final ReleaseMode releaseMode;

    public UploadProgressDialog(@Nullable Shell shell, @Nonnull ReleaseMode releaseMode) {
        super(shell);
        this.releaseMode = Objects.requireNonNull(releaseMode, "Release mode cannot be null.");
        if (releaseMode != ReleaseMode.DEPOT && releaseMode != ReleaseMode.SOUMISSION) {
            throw new IllegalArgumentException("Invalid release mode for an upload: " + releaseMode);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"release.progress.title", (Object[])new Object[0]));
    }

    protected void createCancelButton(Composite parent) {
        this.cancel = this.createButton(parent, 1, Messages.translate((String)"label.button.cancel", (Object[])new Object[0]), true);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.cancel.setCursor(this.arrowCursor);
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.subTaskLabel.setLayoutData((Object)GridDataFactory.createFrom((GridData)((GridData)this.subTaskLabel.getLayoutData())).hint(-1, -1).create());
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        Label alertLabel = new Label(panel, 64);
        alertLabel.setText(Messages.translate((String)(this.releaseMode == ReleaseMode.DEPOT ? "release.progress.depot" : "release.progress.tlv"), (Object[])new Object[0]));
        GridData data = new GridData();
        data.widthHint = 530;
        alertLabel.setLayoutData((Object)data);
        return parent;
    }
}

