/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.PrintJob;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.GeBarcodeGenerator;
import ch.dvbern.tax.ge.pm.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pm.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pm.utils.GeConstants;
import ch.dvbern.tax.ge.pm.utils.SharedUtils;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

class PrepareUploadTask
implements IRunnableWithProgress {
    private final BarcodeConfiguration barcodeConfiguration;
    private final OutputStream pdfStream;
    private final OutputStream barcodeStream;

    PrepareUploadTask(@Nonnull BarcodeConfiguration barcodeConfiguration, @Nonnull OutputStream barcodeStream, @Nonnull OutputStream pdfStream) {
        this.barcodeConfiguration = Objects.requireNonNull(barcodeConfiguration, "Barcode configuration cannot be null.");
        this.barcodeStream = Objects.requireNonNull(barcodeStream, "Barcode stream cannot be null.");
        this.pdfStream = Objects.requireNonNull(pdfStream, "PDF stream cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        try {
            int pdfWorkAmount = 80;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                this.getPdfDeclaPM(this.barcodeConfiguration.getTimestamp(), ctrl, (IProgressMonitor)subMonitor.newChild(pdfWorkAmount), this.pdfStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.pdfStream);
            }
            try {
                GeBarcodeGenerator barcodeGenerator = new GeBarcodeGenerator(false, System.currentTimeMillis(), this.barcodeConfiguration.getReleaseMode(), this.barcodeConfiguration.isWithAttachments());
                byte[] barcode = session.generateBarcode(barcodeGenerator).getData();
                this.barcodeStream.write(barcode);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.barcodeStream);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void getPdfDeclaPM(long timestamp, TaxmeController ctrl, IProgressMonitor monitor, OutputStream pdfStream) throws InvocationTargetException, InterruptedException {
        List<FormKey> formKeys = SharedUtils.getUploadFormKeys((DvbTaxSession)ctrl.getTmoCdSession());
        PrintRequest printRequest = PrintUtilCD.newPrintRequest();
        printRequest.withFormKeys(formKeys);
        FormRendererConfiguration printConfiguration = GeConstants.newPrintConfiguration();
        printConfiguration.withTimestamp(Long.valueOf(timestamp));
        printRequest.withConfiguration(printConfiguration);
        PrintJob pj = new PrintJob(printRequest, pdfStream);
        pj.run(monitor);
    }
}

