/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.justificatifs;

import ch.dvbern.tax.ge.pm.justificatifs.UploadedDocumentType;
import ch.dvbern.tax.ge.pm.utils.InternalFailureException;
import ch.dvbern.tax.ge.pm.utils.SharedUtils;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UploadedDocument {
    private static final String CATEGORY_KEY = "category";
    private static final String PATH_KEY = "path";
    private static final String ORIG_FILENAME = "origFilename";
    private static final String DESCRIPTION_KEY = "description";
    private static final String HASH = "hash";
    private final UploadedDocumentType category;
    private final Path path;
    private final String origFilename;
    private final String description;
    private final String hash;
    private final int hashcode;

    UploadedDocument(@Nonnull UploadedDocumentType category, @Nonnull Path path, @Nonnull String origFilename, @Nonnull String hash, @Nonnull String description) {
        Objects.requireNonNull(category, "Category cannot be null.");
        Objects.requireNonNull(path, "File path cannot be null.");
        Objects.requireNonNull(origFilename, "Original filename cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Objects.requireNonNull(hash, "Hash cannot be null.");
        this.category = category;
        this.path = path;
        this.origFilename = origFilename;
        this.description = description;
        this.hash = hash;
        this.hashcode = new HashCodeBuilder(1445283167, 2048787203).append((Object)category).append((Object)path).append((Object)origFilename).append((Object)description).append((Object)hash).build();
    }

    @Nonnull
    public UploadedDocumentType getCategory() {
        return this.category;
    }

    @Nonnull
    public String getOrigFilename() {
        return this.origFilename;
    }

    @Nonnull
    public String getHash() {
        return this.hash;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UploadedDocument) {
            UploadedDocument that = (UploadedDocument)obj;
            return this.hashcode == that.hashcode && this.category == that.getCategory() && this.path.equals(that.getPath()) && this.origFilename.equals(that.getOrigFilename()) && this.description.equals(that.getDescription());
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.asJson().toString();
    }

    @Nonnull
    static UploadedDocument load(@Nonnull Path dir, @Nonnull JsonObject value) {
        Objects.requireNonNull(dir, "Storage directory cannot be null.");
        Objects.requireNonNull(value, "JSON value cannot be null.");
        try {
            String hash;
            Path docFile = dir.resolve(value.getString(PATH_KEY));
            try {
                hash = value.getString(HASH);
            }
            catch (NullPointerException e) {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(docFile, new OpenOption[0]));){
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    IOUtils.copy((InputStream)is, (OutputStream)new DigestOutputStream((OutputStream)new NullOutputStream(), md));
                    hash = SharedUtils.formatDigest(md);
                }
            }
            return new UploadedDocument(UploadedDocumentType.valueOf(value.getString(CATEGORY_KEY)), docFile, value.getString(ORIG_FILENAME), hash, value.getString(DESCRIPTION_KEY));
        }
        catch (IOException | ClassCastException | IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Cannot load user document info from JSon value: " + value, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalFailureException("Cannot compute digest.", e);
        }
    }

    @Nonnull
    JsonObject asJson() {
        return Json.createObjectBuilder().add(CATEGORY_KEY, this.category.toString()).add(PATH_KEY, this.path.toString()).add(ORIG_FILENAME, this.origFilename).add(DESCRIPTION_KEY, this.description).add(HASH, this.hash).build();
    }
}

