/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.justificatifs;

import ch.dvbern.tax.ge.pm.justificatifs.UploadedDocumentType;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.DocAlreadyStoredException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.DocSizeLimitExceededException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.MaxDocCountExceededException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.StoreSizeLimitExceededException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UnsupportedDocFormatException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UploadedDocument;
import ch.dvbern.tax.ge.pm.utils.InternalFailureException;
import ch.dvbern.tax.ge.pm.utils.SharedUtils;
import com.lowagie.text.pdf.PdfReader;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSDocumentStore
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FSDocumentStore.class);
    public static final long MAX_STORE_SIZE = 0x6400000L;
    public static final long MAX_FILE_SIZE = 0x2800000L;
    public static final int MAX_FILE_COUNT = 10;
    static final String HASH_ALGORITHM = "MD5";
    private Path indexFile;
    private Path docDir;
    private Index index;
    private long totalSize = 0L;

    public FSDocumentStore(@Nonnull Path root) throws IOException {
        Objects.requireNonNull(root, "Root of the store cannot be null.");
        this.createDocumentStore(root);
    }

    private void createDocumentStore(@Nonnull Path root) throws IOException {
        this.docDir = root.resolve("files");
        this.indexFile = root.resolve("index.json");
        Files.createDirectories(this.docDir, new FileAttribute[0]);
        this.index = this.loadIndex(this.indexFile, this.docDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(@Nonnull Path file, @Nonnull UploadedDocumentType category, @Nonnull String description) throws IOException {
        Objects.requireNonNull(file, "File path cannot be null.");
        Objects.requireNonNull(category, "Document category cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Index index = this.index;
        synchronized (index) {
            String hash;
            byte[] pdf;
            if (this.index.getDocs().size() >= 10) {
                throw new MaxDocCountExceededException(String.format("Doc count limit reached (%d/%d).", this.index.getDocs().size(), 10));
            }
            long fileSize = Files.size(file);
            if (fileSize > 0x2800000L) {
                throw new DocSizeLimitExceededException(String.format("Max file size exceeded: %d (limit: %d).", fileSize, 0x2800000L));
            }
            try (DigestInputStream is = new DigestInputStream(Files.newInputStream(file, new OpenOption[0]), MessageDigest.getInstance(HASH_ALGORITHM));){
                pdf = IOUtils.toByteArray((InputStream)is);
                hash = SharedUtils.formatDigest(is.getMessageDigest());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalFailureException("Cannot compute hash.", e);
            }
            for (UploadedDocument userDoc : this.index.getDocs()) {
                if (!hash.equals(userDoc.getHash()) || (long)pdf.length != Files.size(userDoc.getPath())) continue;
                InputStream is = Files.newInputStream(userDoc.getPath(), new OpenOption[0]);
                try {
                    if (!IOUtils.contentEquals((InputStream)new ByteArrayInputStream(pdf), (InputStream)is)) continue;
                    throw new DocAlreadyStoredException();
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if ((long)pdf.length > 0x2800000L) {
                throw new DocSizeLimitExceededException(String.format("Max file size exceeded: %d (limit: %d).", pdf.length, 0x2800000L));
            }
            if ((long)pdf.length + this.index.getTotalSize() > 0x6400000L) {
                throw new StoreSizeLimitExceededException();
            }
            try {
                new PdfReader(pdf);
            }
            catch (Exception e) {
                throw new UnsupportedDocFormatException("Cannot parse as a PDF file.", e);
            }
            Path target = Files.createTempFile(this.docDir, "doc_", ".dat", new FileAttribute[0]);
            Files.copy(new ByteArrayInputStream(pdf), target, StandardCopyOption.REPLACE_EXISTING);
            ArrayList<UploadedDocument> docs = new ArrayList<UploadedDocument>(this.index.docs);
            docs.add(new UploadedDocument(category, target, file.getFileName().toString(), hash, description));
            this.storeIndex(this.indexFile, docs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(UploadedDocument doc, UploadedDocumentType category, String description) throws IOException {
        Objects.requireNonNull(doc, "Document cannot be null.");
        Objects.requireNonNull(category, "Document category cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Index index = this.index;
        synchronized (index) {
            ArrayList<UploadedDocument> docs = new ArrayList<UploadedDocument>(this.index.docs);
            if (!docs.remove(doc)) {
                throw new NoSuchElementException("Document does not exists in store: " + doc);
            }
            docs.add(new UploadedDocument(category, doc.getPath(), doc.getOrigFilename(), doc.getHash(), description));
            this.storeIndex(this.indexFile, docs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UploadedDocument doc) throws IOException {
        Index index = this.index;
        synchronized (index) {
            ArrayList<UploadedDocument> docs = new ArrayList<UploadedDocument>(this.index.docs);
            if (!docs.remove(doc)) {
                throw new NoSuchElementException("No such document: " + doc);
            }
            this.storeIndex(this.indexFile, docs);
            Files.delete(doc.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Index getIndex() {
        Index index = this.index;
        synchronized (index) {
            return this.index.readOnlyCopy();
        }
    }

    private Index loadIndex(Path indexFile, Path docDir) throws IOException {
        assert (indexFile != null && docDir != null);
        ArrayList<UploadedDocument> docs = new ArrayList<UploadedDocument>();
        if (Files.isRegularFile(indexFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(indexFile, StandardCharsets.UTF_8);){
                JsonArray array = Json.createReader((Reader)reader).readArray();
                for (JsonValue value : array) {
                    try {
                        UploadedDocument doc = UploadedDocument.load(docDir, (JsonObject)value);
                        Path path = doc.getPath();
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            this.totalSize += Files.size(path);
                            docs.add(doc);
                            continue;
                        }
                        LOG.error("Ignoring document with invalid path: " + doc);
                    }
                    catch (ClassCastException | IllegalArgumentException e) {
                        LOG.error("Ignoring unparseable JSon object: " + value, (Throwable)e);
                    }
                }
            }
            catch (JsonException e) {
                LOG.error("Failed to parse JSON index file, assume corrupted.", (Throwable)e);
                Files.delete(indexFile);
            }
        }
        Index index = new Index();
        index.docs = docs;
        index.totalSize = this.totalSize;
        return index;
    }

    private void storeIndex(Path indexFile, List<UploadedDocument> docs) throws IOException {
        long totalSize = 0L;
        try (JsonGenerator generator = Json.createGenerator((OutputStream)new BufferedOutputStream(Files.newOutputStream(indexFile, StandardOpenOption.CREATE)));){
            generator.writeStartArray();
            Iterator<UploadedDocument> itr = docs.iterator();
            while (itr.hasNext()) {
                UploadedDocument doc = itr.next();
                Path path = doc.getPath();
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    LOG.error("Ignoring non existing document.");
                    itr.remove();
                    continue;
                }
                totalSize += Files.size(path);
                generator.write((JsonValue)doc.asJson());
            }
            generator.writeEnd();
        }
        this.index.docs = docs;
        this.index.totalSize = totalSize;
    }

    @Override
    public void close() {
        try {
            this.docDir.getFileSystem().close();
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
    }

    public static class Index {
        private List<UploadedDocument> docs;
        private long totalSize;

        @Nonnull
        public List<UploadedDocument> getDocs() {
            return this.docs;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        private Index readOnlyCopy() {
            Index index = new Index();
            index.docs = Collections.unmodifiableList(new ArrayList<UploadedDocument>(this.docs));
            index.totalSize = this.totalSize;
            return index;
        }
    }
}

