/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoTreuhaenderDialog
extends TaxmeTitleAreaDialog {
    private static final Pattern PHONE_NUMBER_PTN = Pattern.compile("[0-9|+]{0,4}[. '/-]{0,3}[0-9]{2,3}[. '/-]{0,3}[0-9]{3}[. '/-]{0,3}[0-9]{2}[. '/-]{0,3}[0-9]{2}");
    private Text textNom;
    private Text textTelephone;

    public InfoTreuhaenderDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"title.shell.info.treuhaender", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.translate((String)"title.info.treuhaender", (Object[])new Object[0]));
        this.setMessage(Messages.translate((String)"label.info.treuhaender", (Object[])new Object[0]));
        return this.createContent(parent);
    }

    private Composite createContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label labelNom = new Label(panel, 64);
        labelNom.setText(Messages.translate((String)"label.mandataire.nom", (Object[])new Object[]{labelNom}));
        GridData gdLabelNom = new GridData(768);
        gdLabelNom.horizontalSpan = 1;
        labelNom.setLayoutData((Object)gdLabelNom);
        this.textNom = new Text(panel, 2048);
        this.textNom.setTextLimit(30);
        GridData gdTextNom = new GridData(768);
        gdTextNom.horizontalSpan = 1;
        this.textNom.setLayoutData((Object)gdTextNom);
        Label labelTelephone = new Label(panel, 64);
        labelTelephone.setText(Messages.translate((String)"label.mandataire.tel", (Object[])new Object[]{labelTelephone}));
        GridData gdLabelTelephone = new GridData(768);
        gdLabelTelephone.horizontalSpan = 1;
        labelTelephone.setLayoutData((Object)gdLabelTelephone);
        this.textTelephone = new Text(panel, 2048);
        this.textTelephone.setTextLimit(25);
        GridData gdTextTelephone = new GridData();
        gdTextTelephone.horizontalSpan = 1;
        gdTextTelephone.widthHint = 100;
        this.textTelephone.setLayoutData((Object)gdTextTelephone);
        String initialName = TaxmeConfig.getString((String)"Declaration_af.Form1_af.RenseignementRaisonSociale");
        String initialPhone = TaxmeConfig.getString((String)"Declaration_af.Form1_af.RenseignementNumTel");
        this.textNom.setText(initialName != null ? initialName : "");
        this.textTelephone.setText(initialPhone != null ? initialPhone : "");
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                InfoTreuhaenderDialog.this.clearErrorStatus((Text)modifyEvent.getSource());
            }
        };
        this.textNom.addModifyListener(listener);
        this.textTelephone.addModifyListener(listener);
        return panel;
    }

    protected void okPressed() {
        String nameValue = this.textNom.getText().trim();
        String phoneValue = this.textTelephone.getText().trim();
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (nameValue.isEmpty() && !phoneValue.isEmpty()) {
            errorMsgs.add("error.missing.data.mandataire.nom");
            this.setErrorStatus(this.textNom);
        }
        if (phoneValue.isEmpty()) {
            if (!nameValue.isEmpty()) {
                errorMsgs.add("error.missing.data.mandataire.phone");
                this.setErrorStatus(this.textTelephone);
            }
        } else if (!PHONE_NUMBER_PTN.matcher(phoneValue).matches()) {
            errorMsgs.add("error.format.tel");
            this.setErrorStatus(this.textTelephone);
        }
        if (!errorMsgs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMsg : errorMsgs) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(Messages.translate((String)errorMsg, (Object[])new Object[0]));
            }
            DialogUtil.showErrorDialog((String)sb.toString(), (Object[])new Object[0]);
            return;
        }
        TaxmeConfig.setValue((String)"Declaration_af.Form1_af.RenseignementRaisonSociale", (String)nameValue);
        TaxmeConfig.setValue((String)"Declaration_af.Form1_af.RenseignementNumTel", (String)phoneValue);
        TaxmeConfig.setValue((String)"Declaration.Form1.RenseignementRaisonSociale", (String)nameValue);
        TaxmeConfig.setValue((String)"Declaration.Form1.RenseignementNumTel", (String)phoneValue);
        super.okPressed();
    }

    private void setErrorStatus(Text txt) {
        txt.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
    }

    private void clearErrorStatus(Text txt) {
        txt.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
    }
}

