/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvoiElectroniqueReadyDialog
extends MessageDialog {
    private static final Logger LOG = LoggerFactory.getLogger(EnvoiElectroniqueReadyDialog.class);
    private final File archive;

    public EnvoiElectroniqueReadyDialog(Shell parentShell, File archive) {
        super(parentShell, Messages.translate((String)"title.dialog.print.televersement", (Object[])new Object[0]), null, Messages.translate((String)"message.dialog.print.televersement", (Object[])new Object[0]), 2, new String[]{Messages.translate((String)"button.suite", (Object[])new Object[0])}, 0);
        if (archive == null) {
            throw new NullPointerException("archive cannot be null");
        }
        this.archive = archive;
    }

    protected Control createCustomArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(0x1000000, 0x1000000).create());
        panel.setLayout((Layout)RowLayoutFactory.swtDefaults().justify(true).fill(true).spacing(12).type(512).create());
        this.addInstructionsLabel(panel, "message.dialog.print.televersement.instructions.1");
        Link lnk = new Link(panel, 0);
        lnk.setText("<a>" + this.archive.getAbsolutePath() + "</a>");
        lnk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EnvoiElectroniqueReadyDialog.this.openLocation();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Menu lnkMenu = new Menu((Control)lnk);
        MenuItem openItem = new MenuItem(lnkMenu, 8);
        openItem.setText(Messages.translate((String)"menu.open.link", (Object[])new Object[0]));
        openItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EnvoiElectroniqueReadyDialog.this.openLocation();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        MenuItem copyItem = new MenuItem(lnkMenu, 8);
        copyItem.setText(Messages.translate((String)"menu.copy.link", (Object[])new Object[0]));
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Clipboard clipboard = new Clipboard(Display.getDefault());
                    clipboard.setContents(new Object[]{EnvoiElectroniqueReadyDialog.this.archive.getAbsolutePath()}, new Transfer[]{TextTransfer.getInstance()});
                }
                catch (SWTError | SWTException e) {
                    LOG.error("Failed to copy url to clipboard.", e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        lnk.setMenu(lnkMenu);
        this.addInstructionsLabel(panel, "message.dialog.print.televersement.instructions.2");
        this.addInstructionsLabel(panel, "message.dialog.print.televersement.instructions.3");
        this.addInstructionsLabel(panel, "message.dialog.print.televersement.instructions.4");
        return panel;
    }

    private Label addInstructionsLabel(Composite parent, String msgKey) {
        Label instructionsLbl = new Label(parent, 64);
        instructionsLbl.setText(Messages.translate((String)msgKey, (Object[])new Object[0]));
        instructionsLbl.setLayoutData((Object)new RowData(600, -1));
        return instructionsLbl;
    }

    private boolean openLocation() {
        return Program.launch((String)this.archive.getParentFile().getAbsolutePath());
    }
}

