/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.ge.pm.envoi.ArchiveGenerationTask;
import ch.dvbern.tax.ge.pm.envoi.GeEnvoiConfiguration;
import ch.dvbern.tax.ge.pm.presentation.cd.dialog.EnvoiElectroniqueReadyDialog;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeEnvoiElectroniqueAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(GeEnvoiElectroniqueAction.class);
    private final Shell shell;

    public GeEnvoiElectroniqueAction(Shell shell) {
        super("dossier.upload.action");
        this.shell = shell;
    }

    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        TaxmeProgressMonitorDialog dlg = new TaxmeProgressMonitorDialog(this.shell);
        ArchiveGenerationTask generationTask = new ArchiveGenerationTask(ctrl.getTmoCdSession());
        File outputFile = generationTask.getOutputFile();
        if (outputFile.exists()) {
            MessageBox mb = new MessageBox(TaxmeController.getInstance().getShell(), 192);
            mb.setText(Messages.translate((String)"warning.upload.fileoverwrite.title", (Object[])new Object[0]));
            mb.setMessage(Messages.translate((String)"warning.upload.fileoverwrite", (Object[])new String[]{outputFile.getAbsolutePath()}));
            int clicked = mb.open();
            switch (clicked) {
                case 64: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        try {
            dlg.run(true, true, (IRunnableWithProgress)generationTask);
        }
        catch (InvocationTargetException e) {
            String messageKey;
            Throwable cause = e.getCause();
            LOG.error("error generating the file", cause);
            String messageTitle = null;
            if (cause instanceof IOException) {
                messageTitle = "title.dialog.envoi.ioexception";
                messageKey = "label.dialog.envoi.ioexception";
            } else {
                messageTitle = "title.dialog.envoi.error";
                messageKey = "label.dialog.envoi.error";
            }
            MessageBox msg = new MessageBox(this.shell, 33);
            msg.setText(Messages.translate((String)messageTitle, (Object[])new Object[0]));
            msg.setMessage(Messages.translate((String)messageKey, (Object[])new Object[0]));
            msg.open();
            return;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        EnvoiElectroniqueReadyDialog msg = new EnvoiElectroniqueReadyDialog(this.shell, outputFile);
        msg.open();
        BrowserUtil.launchURI((String)GeEnvoiConfiguration.UPLOAD_WINDOW_URL.toString());
    }
}

