/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.bd.cd.AbstractDvbTaxCdSessionImpl;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.ge.pm.engine.calcitems.CFPopupMonnaie;
import ch.dvbern.tax.ge.pm.engine.calcitems.CFPopupMonnaie_AF;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.FSDocumentStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeDvbTaxCdSession
extends AbstractDvbTaxCdSessionImpl {
    private static final Logger LOG = LoggerFactory.getLogger(GeDvbTaxCdSession.class);
    private static final Map<String, Object> TAX_FILE_SYSTEM_ENV;
    public static final String ATTACHMENTS_ROOT_DIRECTORY = "/doc";
    private @Nullable Path taxFile;
    private @Nullable File sourceTaxfile = null;

    public GeDvbTaxCdSession() {
        super(TaxmeConfig.getString((String)"path.model.xml"), TaxmeConfig.getDataResource());
    }

    public synchronized File getFile() {
        return this.taxFile != null ? this.taxFile.toFile() : null;
    }

    public synchronized void setFile(File newTaxFile) {
        if (this.taxFile != null && newTaxFile != null) {
            newTaxFile.delete();
            this.manageAttachments(newTaxFile);
        }
        this.taxFile = newTaxFile != null ? newTaxFile.toPath() : null;
        CFPopupMonnaie.showMessage = false;
        CFPopupMonnaie.showMessage = false;
        CFPopupMonnaie_AF.showMessage = false;
    }

    private void manageAttachments(File newTaxFile) {
        try (final FileSystem newTaxfileFileSystem = this.openTaxFileSystem(newTaxFile.toPath());){
            assert (this.taxFile != null);
            try (FileSystem oldTaxfileFileSystem = this.openTaxFileSystem(this.taxFile);){
                Files.walkFileTree(oldTaxfileFileSystem.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path oldTaxfileDir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(newTaxfileFileSystem.getPath(oldTaxfileDir.toString(), new String[0]), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path oldTaxfile, BasicFileAttributes attrs) throws IOException {
                        Files.copy(oldTaxfile, newTaxfileFileSystem.getPath(oldTaxfile.toString(), new String[0]), new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to relocate tax file.", (Throwable)e);
        }
    }

    public synchronized void save() throws IOException {
        if (this.taxFile == null) {
            throw new IllegalStateException("No tax file set, cannot save.");
        }
        this.writeFile(this.taxFile);
        this.setChangesSaved(true);
    }

    private void writeFile(Path file) throws IOException {
        try (FileSystem taxFileFS = this.openTaxFileSystem(file);){
            Path model = taxFileFS.getPath("dvb-tax-model-12345678909876543210", new String[0]);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(model, StandardOpenOption.CREATE));){
                TaxFileUtil.write((OutputStream)out, (Map)this.getDataModel(), (String)"");
            }
        }
    }

    @Nonnull
    public synchronized FSDocumentStore openDocumentStore() throws IOException {
        if (this.taxFile == null) {
            throw new IllegalStateException("Must save-as before opening document store.");
        }
        return new FSDocumentStore(this.openTaxFileSystem(this.taxFile).getPath(ATTACHMENTS_ROOT_DIRECTORY, new String[0]));
    }

    private FileSystem openTaxFileSystem(Path file) throws IOException {
        FileSystem fileSystem;
        assert (file != null);
        URI uri = URI.create("jar:" + file.toUri());
        try {
            fileSystem = FileSystems.newFileSystem(uri, TAX_FILE_SYSTEM_ENV);
        }
        catch (FileSystemAlreadyExistsException e) {
            LOG.info("File system already exists", (Throwable)e);
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    protected Map<String, ModelItemDTO> readDataModel() throws InvalidAuthenticationException, IOException {
        if (this.taxFile == null) {
            return new HashMap<String, ModelItemDTO>(200);
        }
        try (FileSystem taxFileFS = this.openTaxFileSystem(this.taxFile);){
            Map map;
            Path modelFile = taxFileFS.getPath("dvb-tax-model-12345678909876543210", new String[0]);
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(modelFile, new OpenOption[0]));){
                map = TaxFileUtil.read((InputStream)is, (String)"");
            }
            return map;
        }
    }

    public @Nullable TaxFile getTaxFile() {
        if (this.taxFile == null) {
            return null;
        }
        return new TaxFile(this.taxFile.toFile(), null);
    }

    public Map<String, LogicModelItem> getLogicModel() {
        return super.getLogicModel();
    }

    public void setSourceTaxFile(File file) {
        this.sourceTaxfile = file;
    }

    public File getSourceTaxfile() {
        return this.sourceTaxfile;
    }

    public boolean isMonnaieFonctionelle() {
        ModelItemDTO monnaie = this.isDeclarationSA() ? (ModelItemDTO)this.getDataModel().get("Declaration.Form1.MonnaieFonctionnelle") : (ModelItemDTO)this.getDataModel().get("Declaration_af.Form1_af.MonnaieFonctionnelle");
        if (monnaie == null || monnaie.getValue() == null) {
            return false;
        }
        return !monnaie.getValue().toString().equalsIgnoreCase("1");
    }

    public boolean isDeclarationSA() {
        ModelItemDTO selectionSA = (ModelItemDTO)this.getDataModel().get("Selection.SA");
        return selectionSA != null && selectionSA.getValue() != null && (Boolean)selectionSA.getValue() != false;
    }

    static {
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        envMap.put("useTempFile", Boolean.TRUE);
        envMap.put("create", "true");
        TAX_FILE_SYSTEM_ENV = Collections.unmodifiableMap(envMap);
    }
}

