/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.envoi;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeEnvoiConfiguration {
    private static final Logger LOG;
    private static final String DEFAULT_UPLOAD_URL = "https://ge.ch/afcaelteledeclapm";
    private static final String UPLOAD_URL_PROPERTY = "envoi.uploadurl";
    public static final String CRYPT_REMOTE_PUBKEY_ALGO = "RSA";
    private static final String CRYPT_REMOTE_PUBKEY_FILENAME_PROPERTY = "envoi.crypt.pubkey.filename";
    public static final String CRYPT_DATA_ALGO = "AES";
    public static final String CRYPT_DATA_ALGO_SPEC = "AES/ECB/PKCS5Padding";
    public static final int CRYPT_DATA_ALGO_BITS = 128;
    private static final ThreadLocal<MessageFormat> ARCHIVE_FILENAME_MESSAGEFORMAT;
    private static final ThreadLocal<MessageFormat> ARCHIVED_DECLARATION_FILENAME_MESSAGEFORMAT;
    private static final ThreadLocal<MessageFormat> ARCHIVED_XML_BARCODE_MESSAGEFORMAT;
    private static final String EXPORT_DIR_CONFIG_ENTRY = "user.exportdir";
    private static final int ARCHIVE_FILENAME_NAME_PART_MAX_SIZE = 15;
    private static final Map<Integer, String> I18N_TO_ASCII_MAPPING;
    private static final Pattern I18N_TO_ASCII_PTN;
    private static final Pattern ALPHA_NUM_PTN;
    private static final String NON_ALPHA_NUM_REPLACEMENT = "-";
    public static final URL UPLOAD_WINDOW_URL;

    private GeEnvoiConfiguration() {
    }

    public static String getArchiveFilename(String namePart, Date datePart, String noContribuablePart) {
        if (namePart == null || datePart == null || noContribuablePart == null) {
            throw new NullPointerException("invalid null argument");
        }
        return ARCHIVE_FILENAME_MESSAGEFORMAT.get().format(new Object[]{GeEnvoiConfiguration.sanitizeNamePart(namePart), datePart, noContribuablePart});
    }

    public static String getArchivedDeclarationFilename(String namePart, Date datePart, String noContribuablePart) {
        if (namePart == null || datePart == null || noContribuablePart == null) {
            throw new NullPointerException("invalid null argument");
        }
        return ARCHIVED_DECLARATION_FILENAME_MESSAGEFORMAT.get().format(new Object[]{GeEnvoiConfiguration.sanitizeNamePart(namePart), datePart, noContribuablePart});
    }

    public static String getArchivedXmlBarcodeFilename(String namePart, Date datePart, String noContribuablePart) {
        if (namePart == null || datePart == null || noContribuablePart == null) {
            throw new NullPointerException("invalid null argument");
        }
        return ARCHIVED_XML_BARCODE_MESSAGEFORMAT.get().format(new Object[]{GeEnvoiConfiguration.sanitizeNamePart(namePart), datePart, noContribuablePart});
    }

    static String sanitizeNamePart(String namePart) {
        int cp;
        assert (namePart != null) : "invalid null argument";
        StringBuilder sb = new StringBuilder(15);
        boolean nonAlphaNumReplacement = false;
        for (int i = 0; i < namePart.length(); i += Character.charCount(cp)) {
            String token;
            cp = namePart.codePointAt(i);
            String replacement = I18N_TO_ASCII_MAPPING.get(cp);
            if (replacement != null) {
                assert (ALPHA_NUM_PTN.matcher(replacement).matches()) : "non-alpha num replacement";
                nonAlphaNumReplacement = false;
                token = replacement;
            } else {
                String tokenCandidate = new String(Character.toChars(cp));
                if (!ALPHA_NUM_PTN.matcher(tokenCandidate).matches()) {
                    if (!nonAlphaNumReplacement) {
                        token = NON_ALPHA_NUM_REPLACEMENT;
                        nonAlphaNumReplacement = true;
                    } else {
                        token = null;
                    }
                } else {
                    nonAlphaNumReplacement = false;
                    token = tokenCandidate;
                }
            }
            if (token == null) continue;
            if (sb.length() + token.length() > 15) break;
            sb.append(token);
            assert (sb.length() <= 15);
            if (sb.length() >= 15) break;
        }
        String result = sb.toString();
        LOG.debug("Translated '{}' to '{}'", (Object)namePart, (Object)result);
        return result;
    }

    public static URL getUploadWindowUrl() {
        return UPLOAD_WINDOW_URL;
    }

    public static File getExportDir() {
        String dir = TaxmeConfig.getString((String)EXPORT_DIR_CONFIG_ENTRY);
        if (dir == null || "".equals(dir)) {
            return TaxmeConfig.getSaveDir();
        }
        File exportDir = new File(TaxmeConfig.getUserHome(), dir);
        exportDir.mkdirs();
        return exportDir;
    }

    public static File getEncryptionPubkeyFile() {
        String filename = TaxmeConfig.getString((String)CRYPT_REMOTE_PUBKEY_FILENAME_PROPERTY);
        if (filename == null || "".equals(filename)) {
            throw new IllegalStateException("Developer error: config entry envoi.crypt.pubkey.filename not set up correctly");
        }
        return new File(filename);
    }

    static {
        URL url;
        String urlText;
        LOG = LoggerFactory.getLogger(GeEnvoiConfiguration.class);
        ARCHIVE_FILENAME_MESSAGEFORMAT = new ThreadLocal<MessageFormat>(){

            @Override
            protected MessageFormat initialValue() {
                return new MessageFormat("decla_{0}_{1,date,yyyyMMdd-HHmmss}_{2}.taxge");
            }
        };
        ARCHIVED_DECLARATION_FILENAME_MESSAGEFORMAT = new ThreadLocal<MessageFormat>(){

            @Override
            protected MessageFormat initialValue() {
                return new MessageFormat("decla_{0}_{1,date,yyyyMMdd-HHmmss}_{2}.pdf");
            }
        };
        ARCHIVED_XML_BARCODE_MESSAGEFORMAT = new ThreadLocal<MessageFormat>(){

            @Override
            protected MessageFormat initialValue() {
                return new MessageFormat("decla_{0}_{1,date,yyyyMMdd-HHmmss}_{2}.xml");
            }
        };
        I18N_TO_ASCII_PTN = Pattern.compile("(.) = \"(\\p{Alnum}*)\"");
        ALPHA_NUM_PTN = Pattern.compile("\\p{Alnum}");
        InputStream input = GeEnvoiConfiguration.class.getResourceAsStream("i18n-ascii.txt");
        if (input == null) {
            throw new MissingResourceException("Cannot find misc-to-ascii character mapping table", GeEnvoiConfiguration.class.getName(), "i18n-ascii.txt");
        }
        I18N_TO_ASCII_MAPPING = new HashMap<Integer, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                Matcher m = I18N_TO_ASCII_PTN.matcher(line);
                if (!m.matches()) {
                    throw new IllegalStateException("Cannot parse i18n-ascii mapping: " + line);
                }
                String srcCodePoint = m.group(1);
                if (srcCodePoint.codePointCount(0, srcCodePoint.length()) != 1) {
                    throw new IllegalStateException("LHS values must provide exactly one code-point" + line);
                }
                int cp = srcCodePoint.codePointAt(0);
                I18N_TO_ASCII_MAPPING.put(cp, m.group(2));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
        LOG.debug("{} mappings read.", (Object)I18N_TO_ASCII_MAPPING.size());
        try {
            urlText = TaxmeConfig.getString((String)UPLOAD_URL_PROPERTY, (String)DEFAULT_UPLOAD_URL);
        }
        catch (NullPointerException e) {
            urlText = DEFAULT_UPLOAD_URL;
        }
        try {
            url = new URL(urlText);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL in message property envoi.uploadurl: " + urlText, e);
        }
        UPLOAD_WINDOW_URL = url;
    }
}

