/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyCorrespondingValue
implements Validator {
    private final Reference formTable;
    private final Reference selectionItem;
    private final Map<Reference, Reference> sources;

    public CopyCorrespondingValue(Reference formTable, Reference selectionItem, Reference comboItem0, Reference comboItem1, Reference comboItem2, Reference comboItem3, Reference comboItem4, Reference sourceItem0, Reference sourceItem1, Reference sourceItem2, Reference sourceItem3, Reference sourceItem4) {
        this.formTable = formTable;
        this.selectionItem = selectionItem;
        this.sources = new HashMap<Reference, Reference>();
        this.sources.put(comboItem0, sourceItem0);
        this.sources.put(comboItem1, sourceItem1);
        this.sources.put(comboItem2, sourceItem2);
        this.sources.put(comboItem3, sourceItem3);
        this.sources.put(comboItem4, sourceItem4);
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.formTable.registerListenerOnReference(logicModel, logicModelItem, false);
        this.selectionItem.registerListenerOnReference(logicModel, logicModelItem, false);
        for (Map.Entry<Reference, Reference> entry : this.sources.entrySet()) {
            entry.getKey().registerListenerOnReference(logicModel, logicModelItem, true);
            entry.getValue().registerListenerOnReference(logicModel, logicModelItem, true);
        }
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Set formTableIndices;
        ModelItemDTO result = null;
        String formTableDMK = EngineUtil.mergeModelKey((String)this.formTable.getName(), (String)dataModelKey);
        ModelItemDTO formTableDTO = dataModel.get((Object)formTableDMK);
        Set set = formTableIndices = formTableDTO != null ? (Set)formTableDTO.getValue() : null;
        if (formTableIndices != null) {
            for (String index : formTableIndices) {
                String formTableEntryDMK = formTableDMK + "." + index;
                result = this.readSelectionItem(dataModel, dataModelKey, result, formTableEntryDMK);
            }
        }
        return result != null ? result : new ModelItemDTO(null);
    }

    private ModelItemDTO readSelectionItem(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO result, String formTableEntryDMK) {
        String selectionItemDMK = EngineUtil.mergeModelKey((String)this.selectionItem.getName(), (String)dataModelKey);
        ModelItemDTO selectionItemDTO = dataModel.get((Object)selectionItemDMK);
        if (selectionItemDTO != null && selectionItemDTO.getValue() != null) {
            for (Reference comboItem : this.sources.keySet()) {
                result = this.readComboItem(dataModel, result, formTableEntryDMK, selectionItemDTO, comboItem);
            }
        }
        return result;
    }

    private ModelItemDTO readComboItem(LogicModelItem.ProtectedMap dataModel, ModelItemDTO result, String formTableEntryDMK, ModelItemDTO selectionItemDTO, Reference comboItem) {
        String comboItemDMK = EngineUtil.mergeModelKey((String)comboItem.getName(), (String)formTableEntryDMK);
        ModelItemDTO comboItemDTO = dataModel.get((Object)comboItemDMK);
        if (comboItemDTO != null && comboItemDTO.getValue() != null && comboItemDTO.getValue().equals(selectionItemDTO.getValue())) {
            Reference sourceItem = this.sources.get(comboItem);
            String sourceItemDMK = EngineUtil.mergeModelKey((String)sourceItem.getName(), (String)formTableEntryDMK);
            ModelItemDTO sourceItemDTO = dataModel.get((Object)sourceItemDMK);
            result = sourceItemDTO != null ? new ModelItemDTO(sourceItemDTO.getValue()) : new ModelItemDTO(null);
        }
        return result;
    }
}

