/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;

public class ChoixDesignationAnnexeHValidator
implements Validator {
    private final Reference formTable;
    private final Reference designationA;
    private final Reference designationB;
    private final Reference designationC;
    private final Reference designationD;
    private final Reference designationE;

    public ChoixDesignationAnnexeHValidator(Reference formTable, Reference designationA, Reference designationB, Reference designationC, Reference designationD, Reference designationE) {
        this.formTable = formTable;
        this.designationA = designationA;
        this.designationB = designationB;
        this.designationC = designationC;
        this.designationD = designationD;
        this.designationE = designationE;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.designationA == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.designationA.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.designationB == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.designationB.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.designationC == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.designationC.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.designationD == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.designationD.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.designationE == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.designationE.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        String curentValueDesignation = (String)modelItemDTO.getValue();
        ModelItemDTO result = modelItemDTO;
        ModelItemDTO miDTO = dataModel.get((Object)this.formTable.getName());
        if (miDTO == null || miDTO.getValue() == null) {
            return result;
        }
        Set annexeHSet = (Set)miDTO.getValue();
        String annexeHKeyMin = null;
        for (Object anAnnexeHSet : annexeHSet) {
            String valueDesignationD;
            String valueDesignationC;
            String valueDesignationB;
            String valueDesignationA;
            String annexeHKey = anAnnexeHSet.toString();
            if (annexeHKeyMin == null || Long.parseLong(annexeHKey) < Long.parseLong(annexeHKeyMin)) {
                annexeHKeyMin = annexeHKey;
            }
            if (curentValueDesignation == null) continue;
            String keyDesignationA = EngineUtil.mergeModelKey((String)this.designationA.getName(), (String)(this.formTable.getName() + "." + annexeHKey));
            ModelItemDTO designationADTO = dataModel.get((Object)keyDesignationA);
            String string = valueDesignationA = designationADTO != null ? (String)designationADTO.getValue() : null;
            if (valueDesignationA != null && !keyDesignationA.equals(dataModelKey) && valueDesignationA.equals(curentValueDesignation)) {
                result = result.clone(4, "error.AnnexeH.designationDoppeltDefiniert", null, 4);
                return result;
            }
            String keyDesignationB = EngineUtil.mergeModelKey((String)this.designationB.getName(), (String)(this.formTable.getName() + "." + annexeHKey));
            ModelItemDTO designationBDTO = dataModel.get((Object)keyDesignationB);
            String string2 = valueDesignationB = designationBDTO != null ? (String)designationBDTO.getValue() : null;
            if (valueDesignationB != null && !keyDesignationB.equals(dataModelKey) && valueDesignationB.equals(curentValueDesignation)) {
                result = result.clone(4, "error.AnnexeH.designationDoppeltDefiniert", null, 4);
                return result;
            }
            String keyDesignationC = EngineUtil.mergeModelKey((String)this.designationC.getName(), (String)(this.formTable.getName() + "." + annexeHKey));
            ModelItemDTO designationCDTO = dataModel.get((Object)keyDesignationC);
            String string3 = valueDesignationC = designationCDTO != null ? (String)designationCDTO.getValue() : null;
            if (valueDesignationC != null && !keyDesignationC.equals(dataModelKey) && valueDesignationC.equals(curentValueDesignation)) {
                result = result.clone(4, "error.AnnexeH.designationDoppeltDefiniert", null, 4);
                return result;
            }
            String keyDesignationD = EngineUtil.mergeModelKey((String)this.designationD.getName(), (String)(this.formTable.getName() + "." + annexeHKey));
            ModelItemDTO designationDDTO = dataModel.get((Object)keyDesignationD);
            String string4 = valueDesignationD = designationDDTO != null ? (String)designationDDTO.getValue() : null;
            if (valueDesignationD != null && !keyDesignationD.equals(dataModelKey) && valueDesignationD.equals(curentValueDesignation)) {
                result = result.clone(4, "error.AnnexeH.designationDoppeltDefiniert", null, 4);
                return result;
            }
            String keyDesignationE = EngineUtil.mergeModelKey((String)this.designationE.getName(), (String)(this.formTable.getName() + "." + annexeHKey));
            ModelItemDTO designationEDTO = dataModel.get((Object)keyDesignationE);
            String valueDesignationE = designationEDTO != null ? (String)designationEDTO.getValue() : null;
            if (valueDesignationE == null || keyDesignationE.equals(dataModelKey) || !valueDesignationE.equals(curentValueDesignation)) continue;
            result = result.clone(4, "error.AnnexeH.designationDoppeltDefiniert", null, 4);
            return result;
        }
        return result;
    }
}

