/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CheckVersionNr
implements Validator {
    private final Reference dateFinRef;
    private final Reference monneyUsedRef;
    private final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy");

    public CheckVersionNr(Reference dateFinRef, Reference monneyUsedRef) {
        this.dateFinRef = dateFinRef;
        this.monneyUsedRef = monneyUsedRef;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.dateFinRef == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.dateFinRef.registerListenerOnReference(logicModel, logicModelItem, false);
        if (this.monneyUsedRef == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.monneyUsedRef.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        String taxYear = String.valueOf(ApplicationConfig.getInstance().getString("steuerjahr"));
        Date dateFin = this.getDateFin(dataModel, dataModelKey);
        if (taxYear != null && this.versionNrIsLessThanVersion110() && dateFin != null) {
            if (this.isMonneySwiss(dataModel, dataModelKey)) {
                if (this.date1IsAfterDate2(dateFin, "30.12." + taxYear)) {
                    modelItemDTO = modelItemDTO.clone(4, "error.decl.date.ch", null, 4);
                }
            } else if (this.date1IsAfterDate2(dateFin, "30.09." + taxYear)) {
                modelItemDTO = modelItemDTO.clone(4, "error.decl.date", null, 4);
            }
        }
        return modelItemDTO;
    }

    private boolean isMonneySwiss(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.monneyUsedRef.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null) {
            String monney = (String)miDTO.getValue();
            return monney.equals("CHF");
        }
        return false;
    }

    private boolean versionNrIsLessThanVersion110() {
        String[] versionNrSplit;
        ApplicationConfig instance = ApplicationConfig.getInstance();
        String versionNr = instance != null ? String.valueOf(ApplicationConfig.getInstance().getString("versionNr")) : "";
        String[] stringArray = versionNrSplit = versionNr != null ? versionNr.split("\\.") : new String[]{};
        if (versionNrSplit.length > 1) {
            int major = Integer.parseInt(versionNrSplit[0]);
            int minor = Integer.parseInt(versionNrSplit[1]);
            return major < 1 || minor < 10 && major == 1;
        }
        return true;
    }

    private boolean date1IsAfterDate2(Date date1, String date2Str) {
        try {
            Date date2 = this.SDF.parse(date2Str);
            return date1.compareTo(date2) > 0;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private Date getDateFin(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.dateFinRef.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null) {
            return (Date)miDTO.getValue();
        }
        return null;
    }
}

