/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class AVSValidator
implements Validator {
    private final Reference noAVSRef;
    private final Reference formePersonneRef;
    private final Reference domicileRef;
    private final String message;

    public AVSValidator(Reference noAVS, Reference formePersonne, Reference domicile, String message) {
        this.noAVSRef = noAVS;
        this.formePersonneRef = formePersonne;
        this.domicileRef = domicile;
        this.message = message;
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.noAVSRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.formePersonneRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.domicileRef.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        String avsString = "";
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.noAVSRef.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null) {
            avsString = miDTO.getValue().toString();
        }
        Long formePersonne = null;
        ModelItemDTO miDTO2 = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.noAVSRef.getName(), (String)dataModelKey));
        if (miDTO2 != null && miDTO2.getValue() instanceof Number) {
            formePersonne = ((Number)miDTO2.getValue()).longValue();
        }
        Long domicile = null;
        ModelItemDTO miDTO3 = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.noAVSRef.getName(), (String)dataModelKey));
        if (miDTO3 != null && miDTO3.getValue() instanceof Number) {
            domicile = ((Number)miDTO3.getValue()).longValue();
        }
        if (avsString.trim().replaceAll("\\s+", " ").length() != 13) {
            if (formePersonne != null && domicile != null) {
                if (formePersonne.intValue() == 1 && (domicile.intValue() == 2 || domicile.intValue() == 4)) {
                    modelItemDTO = modelItemDTO.clone(1);
                }
            } else {
                modelItemDTO = modelItemDTO.clone(4, this.message, null, 4);
            }
        } else {
            modelItemDTO = modelItemDTO.clone(4, this.message, null, 4);
        }
        return modelItemDTO;
    }
}

