/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.modelitems;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.PersistenceHint;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TableEntryItemSummarizer
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private final Reference rootTable;
    private final Reference[] itemsToSum;
    private final Map<String, Reference> itemsToSumByName = new HashMap<String, Reference>();

    public TableEntryItemSummarizer(String name, String pKey, Reference rootTable, Reference[] itemsToSum) {
        super(name, null, pKey, true, "false", true, false, (PersistenceHint)new SimpleValuePersistenceHint());
        this.rootTable = rootTable;
        this.itemsToSum = (Reference[])itemsToSum.clone();
    }

    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.rootTable.initializeReference(logicModel, (LogicModelItem)this, false);
        ((LogicModelItem.TableItem)this.rootTable.getReference()).addTableEventListener((LogicModelItem.TableItem.TableEventListener)this);
        for (Reference theItem : this.itemsToSum) {
            theItem.registerListenerOnReference(logicModel, (LogicModelItem)this, false);
            this.itemsToSumByName.put(theItem.getName(), theItem);
        }
    }

    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        HashMap<String, ModelItemDTO> newItems = new HashMap<String, ModelItemDTO>();
        for (Map.Entry entry : dataModel.entrySet()) {
            String dmk = (String)entry.getKey();
            if (!this.getName().equals(EngineUtil.removeTableIndices((String)dmk))) continue;
            String newDMK = this.replaceTableEntryIndex(dmk, tableDMK, index);
            newItems.put(newDMK, (ModelItemDTO)entry.getValue());
        }
        for (Map.Entry entry : newItems.entrySet()) {
            super.setValue(dataModel, (String)entry.getKey(), (ModelItemDTO)entry.getValue(), null);
        }
    }

    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
    }

    public void onTableValueRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, ModelItemDTO removedDTO, String tableDMK) {
    }

    public void setValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO, String changedEventsOnlyOutsideOfThisTable) {
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String rootTableEntry;
        if (newValue == null && oldValue == null) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey((String)this.rootTable.getName(), (String)dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart((String)tableDMK);
        Set tableIndices = (Set)dataModel.get((Object)tableDMK).getValue();
        double fieldValuesSum = 0.0;
        for (Object index : tableIndices) {
            rootTableEntry = this.replaceTableEntryIndex(dataModelKey, tableDMK, index.toString());
            for (String name : this.itemsToSumByName.keySet()) {
                Object fieldValue;
                String fieldDmk = EngineUtil.mergeModelKey((String)name, (String)rootTableEntry);
                ModelItemDTO fieldItem = dataModel.get((Object)fieldDmk);
                if (fieldItem == null || !((fieldValue = fieldItem.getValue()) instanceof Number)) continue;
                fieldValuesSum += ((Number)fieldValue).doubleValue();
            }
        }
        for (Object index : tableIndices) {
            rootTableEntry = this.replaceTableEntryIndex(dataModelKey, tableDMK, index.toString());
            String summeDMK = EngineUtil.mergeModelKey((String)this.getName(), (String)rootTableEntry);
            super.setValue(dataModel, summeDMK, new ModelItemDTO((Object)fieldValuesSum), changedEventsOnlyOutsideOfThisTable);
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }
}

