/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pm.presentation.cd.DataResourceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class CFTauxConversion
implements CalcItem {
    private final DataResource dataResource;

    public CFTauxConversion(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        Map.Entry oDay;
        LocalDate theDay;
        double tauxCloture = 0.0;
        double tauxMoyen = 0.0;
        double tauxSum = 0.0;
        String resource = StackUtil.getString((FastStack)stack);
        boolean bCloture = StackUtil.getBoolean((FastStack)stack);
        LocalDate fin = ((Date)stack.pop()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate debut = ((Date)stack.pop()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String monnaie = StackUtil.getString((FastStack)stack);
        Map xChgMap = this.dataResource.get(resource, (Object)monnaie, null);
        long countRates = 0L;
        Iterator iterator = xChgMap.entrySet().iterator();
        while (iterator.hasNext() && !(theDay = ((Date)(oDay = iterator.next()).getKey()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).isBefore(debut)) {
            double aRate;
            if (theDay.isAfter(fin) || !((aRate = ((Double)oDay.getValue()).doubleValue()) > 0.0)) continue;
            if (tauxCloture == 0.0) {
                tauxCloture = aRate;
                if (bCloture) break;
            }
            tauxSum += aRate;
            ++countRates;
        }
        Double quantity = ((DataResourceImpl)this.dataResource).readQuantityCurrency(monnaie);
        if (bCloture) {
            tauxCloture = CFTauxConversion.round(tauxCloture, 5);
            tauxCloture = quantity != null && quantity != 0.0 ? tauxCloture / quantity : tauxCloture;
            stack.push((Object)tauxCloture);
            return;
        }
        if (countRates > 0L) {
            tauxMoyen = CFTauxConversion.round(tauxSum / (double)countRates, 5);
        }
        tauxMoyen = quantity != null && quantity != 0.0 ? tauxMoyen / quantity : tauxMoyen;
        stack.push((Object)tauxMoyen);
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

