/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import java.util.Map;

public class CFBaremeTauxImpot
implements CalcItem {
    private final DataResource dataResource;

    public CFBaremeTauxImpot(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        double montant = 0.0;
        Object montantObj = stack.pop();
        if (montantObj instanceof Number) {
            montant = ((Number)montantObj).doubleValue();
        }
        String filename = stack.pop().toString();
        double impot = this.getImpotPourMontant(montant, filename);
        stack.push((Object)impot);
    }

    private double getImpotPourMontant(double montant, String filename) {
        Map baremes = this.dataResource.get(filename, null, null);
        BaremeImpotDTO hauptTranche = null;
        for (Object o : baremes.values()) {
            BaremeImpotDTO tranche = (BaremeImpotDTO)o;
            if (tranche.getStartTranche() < montant) {
                hauptTranche = tranche;
            }
            if (!(tranche.getEndTranche() > montant)) continue;
            break;
        }
        if (hauptTranche != null) {
            return hauptTranche.getTaux();
        }
        return 0.0;
    }
}

