/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import java.util.Map;

public class CFBaremeImpotTrancheHaute
implements CalcItem {
    private final DataResource dataResource;

    public CFBaremeImpotTrancheHaute(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        double montant = 0.0;
        Object montantObj = stack.pop();
        if (montantObj instanceof Number) {
            montant = ((Number)montantObj).doubleValue();
        }
        String filename = stack.pop().toString();
        double trancheHaute = this.getTranchePourMontant(montant, filename);
        stack.push((Object)trancheHaute);
    }

    private double getTranchePourMontant(double montant, String filename) {
        Map baremes = this.dataResource.get(filename, null, null);
        BaremeImpotDTO mainTranche = null;
        int sizeBaremes = baremes.size() - 1;
        int i = 0;
        for (Object o : baremes.values()) {
            BaremeImpotDTO tranche;
            mainTranche = tranche = (BaremeImpotDTO)o;
            if (++i < sizeBaremes && (!(tranche.getStartTranche() < montant) || !(tranche.getEndTranche() > montant))) continue;
            break;
        }
        if (mainTranche != null) {
            return mainTranche.getEndTranche();
        }
        return 0.0;
    }
}

