/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.ge.pm.utils.DataModelValuesUtil;
import ch.dvbern.tax.ge.pm.utils.TableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CFAnnexeFImmeubles
implements CalcItem {
    public static final Long STATUS_VENTE = 3L;
    public static final String VAL_COMPTABLE_MUT_TYP = "ValComptableMutTyp";
    public static final String VAL_FINE_EXERCISE = "ValComptableFin";

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        int poolSize;
        int numberOfValues;
        List<String> values = this.getIndexesToSearch(stack);
        if (values.isEmpty()) {
            stack.push((Object)true);
            return;
        }
        String pool1 = (String)stack.pop();
        String pool2 = (String)stack.pop();
        if (StringUtils.isEmpty((CharSequence)pool1) && StringUtils.isEmpty((CharSequence)pool2)) {
            stack.push((Object)false);
            return;
        }
        HashSet<String> pool = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)pool1)) {
            pool.addAll(Arrays.asList(pool1.split(";")));
        }
        if (!StringUtils.isEmpty((CharSequence)pool2)) {
            pool.addAll(Arrays.asList(pool2.split(";")));
        }
        if ((numberOfValues = values.size()) != (poolSize = pool.size())) {
            stack.push((Object)false);
            return;
        }
        stack.push((Object)true);
    }

    private List<String> getIndexesToSearch(FastStack stack) {
        DvbTaxCdSession session = TaxmeController.getInstance().getTmoCdSession();
        DataModelValuesUtil dmUtil = new DataModelValuesUtil((DvbTaxSession)session);
        String tableDmk = (String)stack.pop();
        TableIterator itr = dmUtil.getTableIterator(tableDmk);
        ArrayList<String> values = new ArrayList<String>();
        int index = 0;
        while (itr.next()) {
            Long status = dmUtil.getNumber(itr.append(VAL_COMPTABLE_MUT_TYP)).longValue();
            Long valFinExercise = dmUtil.getNumber(itr.append(VAL_FINE_EXERCISE)).longValue();
            if (STATUS_VENTE.equals(status) && (!STATUS_VENTE.equals(status) || valFinExercise <= 0L)) continue;
            Integer rowIndex = 90000 + index;
            values.add(rowIndex.toString());
            ++index;
        }
        return values;
    }
}

