/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms.processing;

import ch.dvbern.lib.pdfforms.processing.ImageProvider;
import ch.dvbern.lib.pdfforms.processing.ProcessorException;
import ch.dvbern.lib.pdfforms.processing.ProcessorOperation;
import ch.dvbern.lib.pdfforms.processing.ProcessorParams;
import java.awt.Color;
import java.awt.Image;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AddImageOperation
implements ProcessorOperation {
    private final @NonNull String name;
    private final  @NonNull Rectangle2D.Float rectangle;
    private final @NonNull ImageProvider imageProvider;

    public AddImageOperation(@NonNull String name,  @NonNull Rectangle2D.Float rectangle, @NonNull ImageProvider imageProvider) {
        this.name = Objects.requireNonNull(name);
        this.rectangle = Objects.requireNonNull(rectangle);
        this.imageProvider = Objects.requireNonNull(imageProvider);
    }

    @Override
    public void apply(@NonNull ProcessorParams params) throws ProcessorException {
        Objects.requireNonNull(params);
        try {
            Image awtImage = this.imageProvider.provideImage();
            if (awtImage == null) {
                return;
            }
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)awtImage, (Color)Color.WHITE);
            image.setAbsolutePosition(this.rectangle.x, this.engineToPT(this.rectangle.y));
            image.scaleAbsolute(this.rectangle.width, this.rectangle.height);
            params.getPdfStamper().getOverContent(1).addImage(image);
        }
        catch (Exception e) {
            throw new ProcessorException("Could not apply postprocessor on image:" + this.name, e);
        }
    }

    private float engineToPT(float value) {
        return value * 28.3465f;
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).build();
    }
}

