/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertContentPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertNavigationPart;
import ch.dvbern.tax.common.presentation.cd.parts.DebugPart;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.MessagePart;
import ch.dvbern.tax.common.presentation.cd.parts.TranslationPart;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeManager;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardContentPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardNavigationPart;
import ch.dvbern.tax.common.presentation.common.Mode;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HorizontalCompositeManager
extends TaxmeCompositeManager {
    private static final String EXTRA_PANEL_HELP_WEIGHT_KEY = "compositeManager.horizontal.extraPanel.help";
    private static final String EXTRA_PANEL_MESSAGES_WEIGHT_KEY = "compositeManager.horizontal.extraPanel.messages";
    private static final String EXTRA_PANEL_TRANSLATIONS_WEIGHT_KEY = "compositeManager.horizontal.extraPanel.translations";
    private static final String EXTRA_PANEL_DEBUG_WEIGHT_KEY = "compositeManager.horizontal.extraPanel.debug";
    private int[] extraPanelWeights;
    private SashForm sashFormHorizontal;
    private SashForm extraPanel;

    @Override
    protected void setupContentInternal(@NonNull Composite parent) {
        this.sashFormHorizontal = new SashForm(parent, 256);
        this.sashFormHorizontal.setLayout((Layout)new FillLayout());
        Mode mode = TaxmeController.getInstance().getMode();
        this.navigationPart = mode == Mode.EXPERT ? new ExpertNavigationPart((Composite)this.sashFormHorizontal) : new WizardNavigationPart((Composite)this.sashFormHorizontal);
        this.contentPart = mode == Mode.EXPERT ? new ExpertContentPart((Composite)this.sashFormHorizontal) : new WizardContentPart((Composite)this.sashFormHorizontal);
        this.setupExtraPanel((Composite)this.sashFormHorizontal);
        this.sashFormHorizontal.setWeights(this.getSashWeightsHorizontalHelpRight(mode));
    }

    private void setupExtraPanel(Composite parent) {
        Mode mode = TaxmeController.getInstance().getMode();
        this.extraPanel = new SashForm(parent, 512);
        ArrayList<Integer> extraPanelWeights = new ArrayList<Integer>();
        if (super.isShortHelpEnabled()) {
            this.helpPart = new HelpPart((Composite)this.extraPanel);
        }
        extraPanelWeights.add(TaxmeConfig.getInt("compositeManager.horizontal.extraPanel.help." + mode.getId(), 85));
        this.messagePart = new MessagePart((Composite)this.extraPanel);
        extraPanelWeights.add(TaxmeConfig.getInt("compositeManager.horizontal.extraPanel.messages." + mode.getId(), 15));
        if (TaxmeConfig.getBoolean("ToolsEnabled")) {
            this.translationPart = new TranslationPart((Composite)this.extraPanel);
            extraPanelWeights.add(TaxmeConfig.getInt("compositeManager.horizontal.extraPanel.translations." + mode.getId(), 20));
        }
        if (TaxmeController.isDevelopmentMode()) {
            DebugPart debugPart = new DebugPart((Composite)this.extraPanel);
            TaxmeController.getInstance().setDebugPart(debugPart);
            extraPanelWeights.add(TaxmeConfig.getInt("compositeManager.horizontal.extraPanel.debug." + mode.getId()), 20);
        }
        this.extraPanelWeights = ArrayUtils.toPrimitive((Integer[])extraPanelWeights.toArray(new Integer[extraPanelWeights.size()]));
        this.extraPanel.setWeights(this.extraPanelWeights);
    }

    @Override
    public void setExtraPanelVisible(boolean extraPanelVisible) {
        if (!extraPanelVisible) {
            if (this.extraPanel != null) {
                this.extraPanelWeights = this.extraPanel.getWeights();
                this.extraPanel.dispose();
                this.extraPanel = null;
                this.helpPart = null;
                this.debugPart = null;
                this.messagePart = null;
                this.translationPart = null;
            }
        } else if (this.extraPanel == null) {
            this.setupExtraPanel((Composite)this.sashFormHorizontal);
            TaxmeController.getInstance().refresh();
        }
        this.sashFormHorizontal.layout(true);
    }

    @Override
    public void bringHelpPart() {
    }

    @Override
    public void bringMessagePart() {
    }

    @Override
    public void bringDebugPart() {
    }

    @Override
    protected void disposeCompositesInternal() {
        this.sashFormHorizontal.dispose();
        this.sashFormHorizontal = null;
        this.extraPanel = null;
    }

    @Override
    public void resizeToDefault() {
        Mode mode = TaxmeController.getInstance().getMode();
        TaxmeConfig.remove("window.sashweights1." + mode.getId() + ".0");
        TaxmeConfig.remove("window.sashweights1." + mode.getId() + ".1");
        TaxmeConfig.remove("window.sashweights1." + mode.getId() + ".2");
        TaxmeConfig.remove("compositeManager.horizontal.extraPanel.help." + mode.getId());
        TaxmeConfig.remove("compositeManager.horizontal.extraPanel.messages." + mode.getId());
        TaxmeConfig.remove("compositeManager.horizontal.extraPanel.translations." + mode.getId());
        TaxmeConfig.remove("compositeManager.horizontal.extraPanel.debug." + mode.getId());
    }

    @Override
    public void saveConfiguration() {
        if (!this.isSetupDone()) {
            return;
        }
        Mode mode = TaxmeController.getInstance().getMode();
        int[] sashWeightsHorizontal = this.sashFormHorizontal.getWeights();
        for (int i = 0; i < sashWeightsHorizontal.length; ++i) {
            TaxmeConfig.setValue("window.sashweights1." + mode.getId() + "." + i, sashWeightsHorizontal[i]);
        }
        if (this.extraPanel != null) {
            this.extraPanelWeights = this.extraPanel.getWeights();
        }
        if (this.extraPanelWeights != null) {
            TaxmeConfig.setValue("compositeManager.horizontal.extraPanel.help." + mode.getId(), this.extraPanelWeights[0]);
            TaxmeConfig.setValue("compositeManager.horizontal.extraPanel.messages." + mode.getId(), this.extraPanelWeights[1]);
            if (this.extraPanelWeights.length > 2) {
                TaxmeConfig.setValue("compositeManager.horizontal.extraPanel.translations." + mode.getId(), this.extraPanelWeights[2]);
            }
            if (this.extraPanelWeights.length > 3) {
                TaxmeConfig.setValue("compositeManager.horizontal.extraPanel.debug." + mode.getId(), this.extraPanelWeights[3]);
            }
        }
    }

    private int[] getSashWeightsHorizontalHelpRight(Mode mode) {
        return new int[]{TaxmeConfig.getInt("window.sashweights1." + mode.getId() + ".0"), TaxmeConfig.getInt("window.sashweights1." + mode.getId() + ".1"), TaxmeConfig.getInt("window.sashweights1." + mode.getId() + ".2")};
    }
}

