/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertContentPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertNavigationPart;
import ch.dvbern.tax.common.presentation.cd.parts.DebugPart;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.MessagePart;
import ch.dvbern.tax.common.presentation.cd.parts.TranslationPart;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeManager;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardContentPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardNavigationPart;
import ch.dvbern.tax.common.presentation.common.Mode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ClassicCompositeManager
extends TaxmeCompositeManager {
    public static final String WINDOW_SASHWEIGHTS1 = "window.sashweights1.";
    public static final String WINDOW_SASHWEIGHTS2 = "window.sashweights2.";
    private SashForm sashFormHorizontal;
    private SashForm sashFormVertical;
    private TabFolder tabFolder;
    private TabItem helpTab;
    private TabItem messageTab;
    private TabItem debugTab;

    @Override
    protected void setupContentInternal(@NonNull Composite parent) {
        this.sashFormHorizontal = new SashForm(parent, 256);
        this.sashFormHorizontal.setLayout((Layout)new FillLayout());
        Mode mode = TaxmeController.getInstance().getMode();
        this.navigationPart = mode == Mode.EXPERT ? new ExpertNavigationPart((Composite)this.sashFormHorizontal) : new WizardNavigationPart((Composite)this.sashFormHorizontal);
        this.sashFormVertical = new SashForm((Composite)this.sashFormHorizontal, 768);
        this.sashFormVertical.setLayout((Layout)new FillLayout());
        this.contentPart = mode == Mode.EXPERT ? new ExpertContentPart((Composite)this.sashFormVertical) : new WizardContentPart((Composite)this.sashFormVertical);
        Composite tabPart = new Composite((Composite)this.sashFormVertical, 2048);
        tabPart.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(tabPart, 0);
        this.tabFolder.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        this.buildHelp();
        this.messageTab = new TabItem(this.tabFolder, 0);
        this.messageTab.setText(Messages.configurableTranslate("label.tab.msg", new Object[0]));
        this.messagePart = new MessagePart((Composite)this.tabFolder);
        this.messageTab.setControl((Control)this.messagePart);
        if (TaxmeConfig.getBoolean("ToolsEnabled")) {
            this.translationPart = new TranslationPart((Composite)this.tabFolder);
            TabItem itemTranslation = new TabItem(this.tabFolder, 0);
            itemTranslation.setData((Object)"label.tab.translation");
            itemTranslation.setText(Messages.configurableTranslate("label.tab.translation", new Object[0]));
            itemTranslation.setControl((Control)this.translationPart);
        }
        if (TaxmeController.isDevelopmentMode()) {
            this.debugPart = new DebugPart((Composite)this.tabFolder);
            this.debugTab = new TabItem(this.tabFolder, 0);
            this.debugTab.setData((Object)"label.tab.debug");
            this.debugTab.setText(Messages.configurableTranslate("label.tab.debug", new Object[0]));
            this.debugTab.setControl((Control)this.debugPart);
            TaxmeController.getInstance().setDebugPart(this.debugPart);
        }
        this.sashFormHorizontal.setWeights(this.getSashWeightsHorizontal(mode));
        this.sashFormVertical.setWeights(this.getSashWeightsVertical(mode));
    }

    protected void buildHelp() {
        if (super.isShortHelpEnabled()) {
            this.helpPart = new HelpPart((Composite)this.tabFolder);
            this.helpTab = new TabItem(this.tabFolder, 0);
            this.helpTab.setData((Object)"label.tab.help");
            this.helpTab.setText(Messages.translate("label.tab.help", new Object[0]));
            this.helpTab.setControl((Control)this.helpPart);
        }
    }

    @Override
    public void setExtraPanelVisible(boolean extraPanelVisible) {
        this.checkSetupDone();
        if (extraPanelVisible) {
            this.sashFormVertical.setMaximizedControl(null);
        } else {
            this.sashFormVertical.setMaximizedControl((Control)this.contentPart);
        }
    }

    @Override
    public void bringHelpPart() {
        if (super.isShortHelpEnabled()) {
            this.tabFolder.setSelection(this.helpTab);
        }
    }

    @Override
    public void bringMessagePart() {
        this.tabFolder.setSelection(this.messageTab);
    }

    @Override
    public void bringDebugPart() {
        this.tabFolder.setSelection(this.debugTab);
    }

    @Override
    protected void disposeCompositesInternal() {
        this.sashFormHorizontal.dispose();
    }

    @Override
    public void resizeToDefault() {
        Mode mode = TaxmeController.getInstance().getMode();
        TaxmeConfig.remove(WINDOW_SASHWEIGHTS1 + mode.getId() + ".0");
        TaxmeConfig.remove(WINDOW_SASHWEIGHTS1 + mode.getId() + ".1");
        TaxmeConfig.remove(WINDOW_SASHWEIGHTS2 + mode.getId() + ".0");
        TaxmeConfig.remove(WINDOW_SASHWEIGHTS2 + mode.getId() + ".1");
        if (this.isSetupDone()) {
            this.sashFormHorizontal.setWeights(this.getSashWeightsHorizontal(mode));
            this.sashFormVertical.setWeights(this.getSashWeightsVertical(mode));
        }
    }

    @Override
    public void saveConfiguration() {
        int[] sashWeightsVertical;
        int i;
        int[] sashWeightsHorizontal;
        Mode mode = TaxmeController.getInstance().getMode();
        if (this.sashFormHorizontal != null && !this.sashFormHorizontal.isDisposed() && (sashWeightsHorizontal = this.sashFormHorizontal.getWeights()).length >= 2) {
            for (i = 0; i < sashWeightsHorizontal.length; ++i) {
                if (sashWeightsHorizontal[i] == 0) {
                    sashWeightsHorizontal[i] = 120;
                }
                TaxmeConfig.setValue(WINDOW_SASHWEIGHTS1 + mode.getId() + "." + i, sashWeightsHorizontal[i]);
            }
        }
        if (this.sashFormVertical != null && !this.sashFormVertical.isDisposed() && (sashWeightsVertical = this.sashFormVertical.getWeights()).length >= 2) {
            for (i = 0; i < sashWeightsVertical.length; ++i) {
                TaxmeConfig.setValue(WINDOW_SASHWEIGHTS2 + mode.getId() + "." + i, sashWeightsVertical[i]);
            }
        }
    }

    private int[] getSashWeightsHorizontal(Mode mode) {
        return new int[]{TaxmeConfig.getInt(WINDOW_SASHWEIGHTS1 + mode.getId() + ".0"), TaxmeConfig.getInt(WINDOW_SASHWEIGHTS1 + mode.getId() + ".1")};
    }

    private int[] getSashWeightsVertical(Mode mode) {
        return new int[]{TaxmeConfig.getInt(WINDOW_SASHWEIGHTS2 + mode.getId() + ".0"), TaxmeConfig.getInt(WINDOW_SASHWEIGHTS2 + mode.getId() + ".1")};
    }
}

