/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintJob;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrintUtilCD {
    private static final Logger LOG = LoggerFactory.getLogger(PrintUtilCD.class);

    private PrintUtilCD() {
    }

    public static boolean printForms(@NonNull PrintRequest printRequest) {
        if (printRequest == null) {
            throw new NullPointerException("Print request cannot be null.");
        }
        return PrintUtilCD.printForms(printRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean printForms(@NonNull PrintRequest printRequest, boolean askForSave) {
        if (printRequest == null) {
            throw new NullPointerException("Print request cannot be null.");
        }
        BufferedOutputStream outputStream = null;
        try {
            File pdf;
            if (askForSave) {
                if (!DialogUtil.showYesNoDialog("message.print.save.pdf", new Object[0])) {
                    boolean bl = true;
                    return bl;
                }
                FileDialog fdlg = new FileDialog(TaxmeController.getInstance().getShell(), 8192);
                fdlg.setFileName(TaxFileConfig.getInstance().getFileName(TaxmeController.getInstance().getTmoCdSession().getDataModel()));
                fdlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
                fdlg.setFilterExtensions(new String[]{"*.pdf"});
                fdlg.setOverwrite(true);
                Object filePath = fdlg.open();
                if (filePath == null) {
                    boolean bl = true;
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    return bl;
                }
                if (!((String)filePath).toLowerCase().endsWith(".pdf")) {
                    filePath = (String)filePath + ".pdf";
                }
                pdf = new File((String)filePath);
            } else {
                File pdfOutputDir = TaxmeConfig.getPdfOutputDir();
                pdf = File.createTempFile("tax_", ".pdf", pdfOutputDir);
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(pdf));
            try {
                PrintJob job = new PrintJob(printRequest, outputStream);
                TaxmeProgressMonitorDialog dlg = new TaxmeProgressMonitorDialog(TaxmeController.getInstance().getShell());
                dlg.run(true, true, job);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            if (!LaunchUtil.launchPdfReader(pdf.getAbsolutePath())) {
                DialogUtil.showErrorDialog("message.acroread.failed", new Object[0]);
                boolean bl = false;
                IOUtils.closeQuietly((OutputStream)outputStream);
                return bl;
            }
            boolean bl = true;
            IOUtils.closeQuietly((OutputStream)outputStream);
            return bl;
        }
        catch (InvocationTargetException e) {
            LOG.error("Printing failed.", (Throwable)e);
            DialogUtil.showErrorDialog("message.printfailed", new Object[0]);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            LOG.debug("Printing interrupted.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Error printing forms.", (Throwable)e);
            DialogUtil.showErrorDialog("message.printfailed", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static PrintRequest newPrintRequest() {
        TaxmeController ctrl = TaxmeController.getInstance();
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
        return new PrintRequest(ctx, ctrl.getImageSource());
    }
}

