/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PrintJob
implements IRunnableWithProgress {
    private final PrintRequest printRequest;
    private final OutputStream outputStream;

    public PrintJob(PrintRequest printRequest, OutputStream outputStream) {
        if (printRequest == null) {
            throw new NullPointerException("Print request cannot be null.");
        }
        if (outputStream == null) {
            throw new NullPointerException("Output stream cannot be null.");
        }
        this.printRequest = printRequest;
        this.outputStream = outputStream;
    }

    public void run(final IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        mon.beginTask(Messages.configurableTranslate("message.print.forms", new Object[0]), this.printRequest.getFormKeys().size());
        ProgressListener li = new ProgressListener(){

            public void formRendered(int form) {
                mon.worked(1);
                if (mon.isCanceled()) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        TaxmeController ctrl = TaxmeController.getInstance();
        try {
            PrintUtil.print((DvbTaxSession)ctrl.getTmoCdSession(), (PrintRequest)this.printRequest.withProgressListener(li), (OutputStream)this.outputStream, (boolean)false);
        }
        catch (FormRendererException e) {
            throw new InvocationTargetException(e);
        }
        mon.done();
    }
}

