/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import java.io.IOException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LaunchUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchUtil.class);

    private LaunchUtil() {
    }

    public static boolean launch(@NonNull String filepath) {
        boolean success;
        if (filepath == null) {
            throw new NullPointerException("File name cannot be null.");
        }
        if (Display.getCurrent() != null) {
            success = Program.launch((String)filepath);
        } else {
            ProgramLaunchRunnable plr = new ProgramLaunchRunnable(filepath);
            try {
                Display.getDefault().syncExec((Runnable)plr);
                success = plr.isSuccess();
            }
            catch (SWTException e) {
                success = false;
                LOG.error("Failed to launch default program.", (Throwable)e);
            }
        }
        return success;
    }

    public static boolean launch(@NonNull String useConfigKey, @NonNull String programPathKey, @NonNull String filepath) {
        if (useConfigKey == null || programPathKey == null || filepath == null) {
            throw new NullPointerException("Invalid null argument.");
        }
        boolean useConfig = TaxmeConfig.getBoolean(useConfigKey);
        String programPath = TaxmeConfig.getString(programPathKey);
        if (useConfig && programPath != null && !programPath.isEmpty()) {
            Object[] cmd = OsUtil.isOsMac() ? new String[]{"open", "-a", programPath, filepath} : new String[]{programPath, filepath};
            try {
                LOG.debug("Open file with command: '" + Arrays.toString(cmd) + "'");
                Runtime.getRuntime().exec((String[])cmd);
            }
            catch (IOException e) {
                LOG.error("Failed to start user-specified program: '" + Arrays.toString(cmd) + "'", (Throwable)e);
                return false;
            }
            return true;
        }
        LOG.debug("'" + filepath + "': no user program specified use system default.");
        return LaunchUtil.launch(filepath);
    }

    public static boolean launchPdfReader(@NonNull String filepath) {
        return LaunchUtil.launch("acroread.path.use", "acroread.path", filepath);
    }

    public static boolean launchBrowser(@NonNull String filepath) {
        return LaunchUtil.launch("browser.path.use", "browser.path", filepath);
    }

    private static class ProgramLaunchRunnable
    implements Runnable {
        private final String filename;
        private volatile boolean success;

        public ProgramLaunchRunnable(String filename) {
            assert (filename != null);
            this.filename = filename;
        }

        @Override
        public void run() {
            this.success = Program.launch((String)this.filename);
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

