/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.treestructure;

import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeStructureNewGui
extends Dialog
implements FocusListener,
ISelectionChangedListener,
IModelChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(TreeStructureNewGui.class);
    private HelpItem newHelpItem;
    private final HelpItem parentItem;
    private Browser browser;
    private Text linkDescription;
    private Text htmlDoc;
    private IToolCommunicationGui callback = null;

    public TreeStructureNewGui(Shell parentShell, IToolCommunicationGui pCallback, HelpItem pParentItem) {
        super(parentShell);
        this.parentItem = pParentItem;
        this.callback = pCallback;
        this.newHelpItem = new HelpItem("", "", "");
        this.newHelpItem.addModelChangedListener(this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New topic");
        shell.setSize(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        GridLayout layout = new GridLayout(4, false);
        panel.setLayout((Layout)layout);
        GridDataFactory textFieldGDF = GridDataFactory.swtDefaults().hint(200, -1);
        Label linkDescriptionLabel = new Label(panel, 0);
        linkDescriptionLabel.setText("Link Description");
        this.linkDescription = new Text(panel, 2048);
        this.linkDescription.setLayoutData((Object)textFieldGDF.copy().span(3, 1).create());
        this.linkDescription.setData((Object)"description");
        this.linkDescription.addFocusListener((FocusListener)this);
        Label htmlDocLabel = new Label(panel, 0);
        htmlDocLabel.setText("HTML Document");
        this.htmlDoc = new Text(panel, 2048);
        this.htmlDoc.setData((Object)"document");
        this.htmlDoc.addFocusListener((FocusListener)this);
        this.htmlDoc.setLayoutData((Object)textFieldGDF.create());
        Button browse = new Button(panel, 8);
        browse.setText("Browse");
        browse.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                TreeStructureNewGui.this.browseClicked();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        });
        Composite browserPanel = new Composite(panel, 0);
        browserPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(4, 1).create());
        FillLayout fillLayout = new FillLayout();
        browserPanel.setLayout((Layout)fillLayout);
        Group group0 = new Group(browserPanel, 0);
        group0.setText("HTML Preview");
        fillLayout = new FillLayout();
        fillLayout.type = 512;
        group0.setLayout((Layout)fillLayout);
        this.browser = new Browser((Composite)group0, 8);
        return panel;
    }

    private void browseClicked() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        String[] fileExtension = new String[]{"*.html;*.htm"};
        fileBrowser.setFilterExtensions(fileExtension);
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        fileBrowser.setFilterPath(mainHelpDir);
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            this.newHelpItem.setTopic(fileBrowser.getFileName());
        }
    }

    protected void okPressed() {
        if (this.parentItem == null) {
            HelpRoot root = this.callback.toolGetMainHelpModel();
            root.addModelChangedListener(this);
            this.newHelpItem.setParent(root);
            root.addItem(this.newHelpItem);
        } else {
            this.newHelpItem.setParent(this.parentItem);
            this.parentItem.addItem(this.newHelpItem);
        }
        super.okPressed();
    }

    private void displayHTML(HelpItem item) {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + item.getTopic());
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                this.browser.setUrl(url.toExternalForm());
            } else {
                this.browser.setText("");
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Error displaying HTML mainHelp: ", (Throwable)e);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof Text) {
            Text focusedText = (Text)e.getSource();
            if (focusedText.getData().equals("description")) {
                this.newHelpItem.setName(focusedText.getText());
            } else if (focusedText.getData().equals("document")) {
                this.newHelpItem.setTopic(focusedText.getText());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public boolean close() {
        if (this.newHelpItem != null) {
            this.newHelpItem.removeModelChangedListener(this);
        }
        this.newHelpItem = null;
        return super.close();
    }

    @Override
    public void refreshView(HelpItem item, String property) {
        if (item != null) {
            this.linkDescription.setText(item.getName());
            this.htmlDoc.setText(item.getTopic());
            this.displayHTML(item);
        }
    }

    @Override
    public void refreshView(HelpRoot root, String property) {
    }
}

