/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.mapping;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.help.util.EditableHelpMapping;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortHelpMappingOnControlsGui
extends Dialog
implements SelectionListener,
FocusListener {
    private static final Logger LOG = LoggerFactory.getLogger(ShortHelpMappingOnControlsGui.class);
    private Browser shortBrowser;
    private Text shortLinkDesc;
    private IToolCommunicationGui callback = null;
    private String key = null;

    public ShortHelpMappingOnControlsGui(IToolCommunicationGui callback, String key) {
        super(callback.getCallBackShell());
        this.callback = callback;
        this.key = key;
    }

    public IToolCommunicationGui getCallback() {
        return this.callback;
    }

    protected Control createDialogArea(Composite parent) {
        ((Shell)parent).setText("Taxme Tools");
        parent.setSize(800, 600);
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        Group shortHelp = new Group(parent, 0);
        shortHelp.setText("Short Help");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(90, 0);
        shortHelp.setLayoutData((Object)data);
        formLayout = new FormLayout();
        shortHelp.setLayout((Layout)formLayout);
        Label shortLinkDescLabel = new Label((Composite)shortHelp, 0);
        shortLinkDescLabel.setText("Link Description");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment(0, 10);
        shortLinkDescLabel.setLayoutData((Object)data);
        Label shortHtmlPreview = new Label((Composite)shortHelp, 0);
        shortHtmlPreview.setText("HTML Preview");
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 10);
        shortHtmlPreview.setLayoutData((Object)data);
        this.shortLinkDesc = new Text((Composite)shortHelp, 2048);
        this.shortLinkDesc.setText(this.callback.toolGetCurrentShortHelpFileNameOnField(this.key));
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)shortLinkDescLabel, 10, -1);
        this.shortLinkDesc.addFocusListener((FocusListener)this);
        this.shortLinkDesc.setData((Object)"short");
        this.shortLinkDesc.setLayoutData((Object)data);
        Button shortBrowse = new Button((Composite)shortHelp, 8);
        shortBrowse.setText("Browse");
        shortBrowse.setData((Object)2);
        shortBrowse.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)this.shortLinkDesc, 10, -1);
        shortBrowse.setLayoutData((Object)data);
        this.shortBrowser = new Browser((Composite)shortHelp, 0);
        this.displayHTMLShort();
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)shortHtmlPreview, 10, -1);
        data.bottom = new FormAttachment(100, 0);
        this.shortBrowser.setLayoutData((Object)data);
        Button ok = new Button(parent, 8);
        ok.setText("OK");
        ok.setData((Object)0);
        ok.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(30, 0);
        data.right = new FormAttachment(48, 0);
        data.top = new FormAttachment((Control)shortHelp, 10, -1);
        ok.setLayoutData((Object)data);
        Button cancel = new Button(parent, 8);
        cancel.setText("Cancel");
        cancel.setData((Object)1);
        cancel.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(52, 0);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment((Control)shortHelp, 10, -1);
        cancel.setLayoutData((Object)data);
        parent.layout();
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    private void displayHTMLShort() {
        String shortHelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        URL url = null;
        try {
            url = new URL("file:" + shortHelpDir + "/" + this.shortLinkDesc.getText());
            LOG.debug("URL = " + String.valueOf(url));
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                this.shortBrowser.setUrl(url.toExternalForm());
            } else {
                this.shortBrowser.setText("");
            }
        }
        catch (Exception e) {
            LOG.error("error displaying: " + shortHelpDir + " = " + String.valueOf(url), (Throwable)e);
        }
    }

    private void displayHTMLShort(String fileName) {
        String shortHelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + shortHelpDir + "/" + fileName);
            LOG.debug("URL = " + String.valueOf(url));
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                this.shortBrowser.setUrl(url.toExternalForm());
            } else {
                this.shortBrowser.setText("");
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Error displaying: " + fileName, (Throwable)e);
        }
    }

    protected Layout getLayout() {
        return new FormLayout();
    }

    protected Control createContents(Composite composite) {
        ShortHelpMappingOnControlsGui.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    public boolean close() {
        return super.close();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            int data = (Integer)selectedButton.getData();
            switch (data) {
                case 0: {
                    this.ok();
                    break;
                }
                case 1: {
                    this.cancel();
                    break;
                }
                case 2: {
                    this.browseShort();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void ok() {
        if (this.shortLinkDesc.getText() != null) {
            TaxmeController ctrl = TaxmeController.getInstance();
            EditableHelpMapping shortHelpMapping = ctrl.getShortHelpMapping();
            if (!this.shortLinkDesc.getText().equals("")) {
                shortHelpMapping.set(this.key, this.shortLinkDesc.getText());
                ctrl.storeHelpMapping();
                this.callback.toolRefreshHelpMappings();
            } else {
                shortHelpMapping.remove(this.key);
                ctrl.storeHelpMapping();
                this.callback.toolRefreshHelpMappings();
            }
        }
        this.close();
    }

    private void cancel() {
        this.close();
    }

    private void browseShort() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        String shorthelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        fileBrowser.setFilterPath(shorthelpDir);
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            String linkDesc = fileBrowser.getFileName();
            this.shortLinkDesc.setText(linkDesc);
            this.displayHTMLShort(linkDesc);
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        if (arg0.getSource() instanceof Text) {
            Text textComponent = (Text)arg0.getSource();
            String text = textComponent.getText();
            if (textComponent.getData().equals("short")) {
                this.displayHTMLShort(text);
            }
        }
    }
}

