/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.TablerowClickAction;
import ch.dvbern.tax.common.presentation.cd.builders.ControlBuilderFactory;
import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.EnhancedTableRowBuilder;
import ch.dvbern.tax.common.presentation.cd.items.IItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableColumn;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WTableItem;
import ch.dvbern.tax.common.presentation.cd.parts.CreateTableButtonAreaPart;
import ch.dvbern.tax.common.presentation.cd.parts.ITablePart;
import ch.dvbern.tax.common.presentation.cd.parts.TableContentProvider;
import ch.dvbern.tax.common.presentation.cd.parts.TableLabelProvider;
import ch.dvbern.tax.common.presentation.cd.parts.TableRowDeleteButton;
import ch.dvbern.tax.common.presentation.cd.parts.TableViewerSorter;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeTable;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeTableColumn;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TablePart
extends TaxmeComposite
implements ITablePart {
    private int firstColumnWidth;
    private final ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private final SortListener sortListener = new SortListener();
    private @Nullable TaxmeTable table;
    private ITableItem tableDTO;
    private TableViewer tableViewer;
    private final IDoubleClickListener doubleClickListener;
    private final ISelectionChangedListener selectionChangedListener;
    private boolean initialized = false;
    private final ControlBuilderFactory controlBuilderFactory = ControlBuilderFactory.getInstance();
    private final Director director = new Director();
    private final EnhancedTableRowBuilder enhancedRowBuilder = new EnhancedTableRowBuilder();
    private ControlPanelHolder controlPanelHolder;
    private boolean tableColumnSortEnabled;
    private final Map<String, TableSort> tableSorts;

    public TablePart(Composite parent) {
        super(parent, 0);
        String sTableColumnSortEnabled = TaxmeConfig.getString("table.column.sort.enabled");
        if (sTableColumnSortEnabled != null && sTableColumnSortEnabled.equals("true")) {
            this.tableColumnSortEnabled = true;
        }
        this.setLayoutData(new GridData(2));
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (TablePart.this.table != null && !TablePart.this.table.isDisposed()) {
                    TablePart.this.parentResized();
                }
            }
        });
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TaxmeController.getInstance().createModelSnapshot();
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ITableRow rowItemDTO = (ITableRow)selection.getFirstElement();
                String newDMK = rowItemDTO.getDmkTableEntry();
                TaxmeController.getInstance().setDataModelKey(newDMK);
            }
        };
        final TablerowClickAction tablerowClickAction = (TablerowClickAction)ActionRegistry.getInstance().getAction("table.row.click");
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tablerowClickAction.run(event);
            }
        };
        this.tableSorts = TaxmeConfig.getTableSorts(TaxmeController.getInstance().getMode());
    }

    @Override
    public void init(ITableItem tableDTO) {
        this.tableDTO = tableDTO;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = tableDTO.getColspan();
        gd.verticalSpan = tableDTO.getRowspan();
        if (tableDTO.isVariableHeight()) {
            GridLayout gl;
            if (!(this.getLayout() instanceof GridLayout)) {
                gl = new GridLayout(1, false);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                this.setLayout((Layout)gl);
            }
            gl = (GridLayout)this.getLayout();
            gl.verticalSpacing = tableDTO.getTitleKey() != null ? 5 : 0;
        } else if (!(this.getLayout() instanceof FillLayout)) {
            this.setLayout((Layout)new FillLayout());
        }
        if (!"fill".equalsIgnoreCase(tableDTO.getAlign())) {
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalAlignment = 1;
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        this.controlReuseUtil.start();
        this.createHeader();
        if (!tableDTO.isVisible()) {
            this.controlReuseUtil.end();
            if (this.table != null) {
                this.table.dispose();
                this.table = null;
                this.tableViewer = null;
            }
            return;
        }
        this.initTable();
        this.initColumns();
        if (tableDTO.isEditable()) {
            this.createEditableRows();
        } else {
            this.createReadOnlyRows();
        }
        this.controlReuseUtil.end();
        this.parentResized();
        if (OsSupport.isLinuxOs() && tableDTO.isEditable() && !this.initialized && tableDTO instanceof WTableItem) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Point size = TablePart.this.getSize();
                    TablePart.this.setSize(0, 0);
                    TablePart.this.setSize(size);
                }
            });
            this.initialized = true;
        }
        if (OsSupport.isMacOs() && tableDTO.isEditable() && !this.initialized && tableDTO instanceof WTableItem) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control[] ctrls;
                    for (Control ctrl : ctrls = TablePart.this.table.getChildren()) {
                        ctrl.traverse(16);
                    }
                }
            });
            this.initialized = true;
        }
    }

    private void initTable() {
        if (this.table != null) {
            return;
        }
        GridData gd = new GridData(768);
        if ("left".equalsIgnoreCase(this.tableDTO.getAlign())) {
            gd.horizontalAlignment = 1;
            gd.grabExcessHorizontalSpace = false;
        } else if ("center".equalsIgnoreCase(this.tableDTO.getAlign())) {
            gd.horizontalAlignment = 2;
            gd.grabExcessHorizontalSpace = false;
        } else if ("right".equalsIgnoreCase(this.tableDTO.getAlign())) {
            gd.horizontalAlignment = 3;
            gd.grabExcessHorizontalSpace = false;
        }
        int style = 0;
        if (!this.tableDTO.isEditable()) {
            style |= 0x18004;
        }
        if (gd.horizontalAlignment != 4) {
            style |= 0x800;
        }
        this.table = new TaxmeTable(this, style);
        this.table.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_BACKGROUND));
        this.table.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND));
        this.table.setHeaderVisible(this.tableDTO.isHeaderVisible());
        this.table.setEnabled(true);
        this.table.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        this.table.setLayoutData(gd);
        this.table.setLinesVisible(!OsSupport.isMacOs() || !this.tableDTO.isEditable());
        this.controlPanelHolder = new ControlPanelHolder((Composite)this.table, this.controlReuseUtil);
        if (this.tableDTO.isEditable()) {
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TablePart.this.table.setSelection(1, 0);
                        }
                    });
                }
            });
        } else {
            this.table.addSelectionListener((SelectionListener)new ScrollToVisibleListener());
        }
    }

    private void initColumns() {
        TaxmeController ctrl = TaxmeController.getInstance();
        DisplayItemUniqueID id = this.tableDTO.getUID().appendLocal(".status");
        TaxmeTableColumn column1 = (TaxmeTableColumn)this.controlReuseUtil.getWidget(id);
        if (column1 == null) {
            column1 = new TaxmeTableColumn(this.table, 16384);
            this.controlReuseUtil.addWidget(id, (Widget)column1);
        }
        if (this.tableDTO.isEditable() || this.tableDTO.isReadOnly()) {
            column1.setText("");
            column1.setData("");
            column1.setToolTipText(null);
            this.firstColumnWidth = 27;
        } else {
            String title = Messages.configurableTranslate("label.status", new Object[0]);
            column1.setText(title);
            if (title != null && !title.isEmpty()) {
                column1.setToolTipText(title);
            } else {
                column1.setToolTipText(null);
            }
            column1.setData("label.status");
            this.firstColumnWidth = 45;
        }
        TableSort tableSort = null;
        if (this.tableColumnSortEnabled) {
            String tableDmk = EngineUtil.removeTableIndices((String)this.tableDTO.getTableDmk());
            tableSort = TaxmeConfig.getTableSorts(ctrl.getMode()).get(tableDmk);
            if (tableSort != null) {
                this.table.setSortDirection(tableSort.isAsc() ? 128 : 1024);
            }
        }
        int curentColumnIndex = -1;
        for (ITableColumn iTableColumn : this.tableDTO.getColdefs()) {
            TaxmeTableColumn column = (TaxmeTableColumn)this.controlReuseUtil.getWidget(iTableColumn.getUID());
            if (column == null) {
                int alignment = 16384;
                if (!this.tableDTO.isEditable()) {
                    if ("center".equalsIgnoreCase(iTableColumn.getAlign())) {
                        alignment = 0x1000000;
                    } else if ("right".equalsIgnoreCase(iTableColumn.getAlign())) {
                        alignment = 131072;
                    }
                }
                column = new TaxmeTableColumn(this.table, alignment);
                this.controlReuseUtil.addWidget(iTableColumn.getUID(), (Widget)column);
                if (this.tableColumnSortEnabled) {
                    column.addSelectionListener((SelectionListener)this.sortListener);
                    curentColumnIndex = this.table.indexOf(column);
                    if (tableSort != null && curentColumnIndex == tableSort.getIndex()) {
                        this.table.setSortColumn(column);
                    }
                }
            }
            String title = "";
            if (iTableColumn.getHeaderKey() != null) {
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.tableDTO.getTableDmk());
                Object[] args = WizardLabelAddOnHelper.getReplacements(iTableColumn.getHeaderAddOns(), (AbstractConverter.ConverterContext)ctx);
                title = Messages.configurableTranslate(iTableColumn.getHeaderKey(), args);
            }
            column.setText(title);
            if (title != null && !title.isEmpty()) {
                column.setToolTipText(title);
                continue;
            }
            column.setToolTipText(null);
        }
    }

    private void createReadOnlyRows() {
        if (this.tableViewer == null) {
            this.tableViewer = new TableViewer((Table)this.table);
            this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.tableViewer.setUseHashlookup(true);
            if (!this.tableDTO.isReadOnly()) {
                this.tableViewer.addDoubleClickListener(this.doubleClickListener);
                this.tableViewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(this.tableViewer));
        }
        if (!this.tableDTO.isReadOnly()) {
            DisplayItemUniqueID id = this.tableDTO.getUID().appendLocal(".table.buttons");
            CreateTableButtonAreaPart addEditDeleteButtons = (CreateTableButtonAreaPart)this.controlReuseUtil.getControl(id);
            if (addEditDeleteButtons == null) {
                addEditDeleteButtons = new CreateTableButtonAreaPart((Composite)this, this.tableDTO.getOnlyShowVisualizeButton());
                addEditDeleteButtons.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
                addEditDeleteButtons.setLayoutData(new GridData(64));
                this.controlReuseUtil.addControl(id, (Control)addEditDeleteButtons);
            }
            addEditDeleteButtons.init(this.tableViewer);
        }
        this.tableViewer.setInput((Object)this.tableDTO);
        this.tableViewer.refresh();
    }

    private void createHeader() {
        if (this.tableDTO.getTitleKey() == null) {
            return;
        }
        DisplayItemUniqueID id = this.tableDTO.getUID().appendLocal(".header");
        BorderedLabel label = (BorderedLabel)this.controlReuseUtil.getControl(id);
        if (label == null) {
            label = new BorderedLabel(this, 2, 1, 1, null, 64);
            this.controlReuseUtil.addControl(id, (Control)label);
            Color foreground = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_HEADER_FOREGROUND);
            if (!this.tableDTO.isVisible()) {
                foreground = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_HEADER_FOREGROUND_TRANSPARENT);
            }
            label.setForeground(foreground);
            label.setFont(GuiUtil.getFontRegistry().get("font.header.table"));
        }
        TaxmeController ctrl = TaxmeController.getInstance();
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.tableDTO.getTableDmk());
        Object[] args = WizardLabelAddOnHelper.getReplacements(this.tableDTO.getLabelAddOns(), (AbstractConverter.ConverterContext)ctx);
        label.setText(Messages.configurableTranslate(this.tableDTO.getTitleKey(), (Control)label.getNestedLabel(), args));
        label.setData(this.tableDTO.getTitleKey());
        Color background = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_HEADER_BACKGROUND);
        if (!this.tableDTO.isVisible()) {
            background = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_HEADER_BACKGROUND_TRANSPARENT);
        }
        label.setBackground(background);
    }

    private void createEditableRows() {
        if (this.tableViewer != null) {
            this.tableViewer.setInput(null);
        }
        this.tableDTO.applySorts(this.tableSorts);
        int i = 0;
        if (this.tableDTO.getRows() != null) {
            for (ITableRow iTableRow : this.tableDTO.getRows()) {
                this.createEditableRow(iTableRow, i);
                ++i;
            }
        }
        if (this.tableDTO.getEmptyRow() != null) {
            this.createEditableRow(this.tableDTO.getEmptyRow(), i);
        }
    }

    private void createEditableRow(ITableRow row, int idx) {
        TableItem tableItem = this.getTableItem(row, idx);
        tableItem.setData((Object)row.getUID());
        if (row.isDeletable()) {
            DisplayItemUniqueID deleteCellId = row.getUID().appendLocal(".delete");
            TableRowDeleteButton deleteCell = (TableRowDeleteButton)this.controlReuseUtil.getControl(deleteCellId);
            if (deleteCell == null) {
                deleteCell = new TableRowDeleteButton(this.table);
                this.controlReuseUtil.addControl(deleteCellId, (Control)deleteCell);
            }
            deleteCell.setRow(row.getDmkTableEntry());
            deleteCell.setEnabled(row.isDeletable());
            this.getTableEditor(deleteCellId, tableItem, 0, (Control)deleteCell);
        }
        if (this.tableDTO.isEnhanced()) {
            this.enhancedRowBuilder.init(row);
            this.director.init(this.enhancedRowBuilder, this.controlPanelHolder);
            this.director.createControl();
            Control c = this.enhancedRowBuilder.getControl();
            this.getTableEditor(row.getUID().appendLocal(".enhanced"), tableItem, 1, c);
        } else {
            int j = this.tableDTO.isFirstColumnStatus() ? 0 : 1;
            for (Object element : row.getCells()) {
                IItem item;
                IControlBuilder builder;
                if (element instanceof IItem && (builder = this.controlBuilderFactory.createBuilder(item = (IItem)element)) != null) {
                    this.director.init(builder, this.controlPanelHolder);
                    this.director.createControl();
                    this.getTableEditor(item.getUID(), tableItem, j, builder.getControl());
                }
                ++j;
            }
        }
    }

    private TableItem getTableItem(ITableRow rowDTO, int index) {
        DisplayItemUniqueID id = rowDTO.getUID().appendLocal(".row");
        TableItem item = (TableItem)this.controlReuseUtil.getWidget(id);
        if (item == null) {
            item = new TableItem((Table)this.table, 0, index);
            item.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            if (this.tableDTO.getRowHeigth() > 0) {
                final Image rowHeightImage = new Image(null, 1, this.tableDTO.getRowHeigth());
                item.setImage(rowHeightImage);
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent ev) {
                        rowHeightImage.dispose();
                    }
                });
            }
            this.controlReuseUtil.addWidget(id, (Widget)item);
        }
        return item;
    }

    private TableEditor getTableEditor(DisplayItemUniqueID id, TableItem tableItem, int column, Control ctrl) {
        DisplayItemUniqueID editorId = id.appendLocal(".editor");
        TableEditor editor = (TableEditor)this.controlReuseUtil.getControlEditor(editorId);
        if (editor == null) {
            editor = new TableEditor((Table)this.table);
            this.controlReuseUtil.addControlEditor(editorId, (ControlEditor)editor);
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setColumn(column);
            editor.setItem(tableItem);
        } else {
            if (editor.getItem() != tableItem) {
                editor.setItem(tableItem);
            }
            if (editor.getColumn() != column) {
                editor.setColumn(column);
            }
        }
        editor.setEditor(ctrl);
        return editor;
    }

    private void parentResized() {
        Rectangle area = this.getClientArea();
        Point preferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth() - 22;
        if (preferredSize.y > area.height + this.table.getHeaderHeight()) {
            Point vBarSize = this.table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.table.getSize();
        if (oldSize.x > area.width) {
            this.updateColumnWidths(width);
            this.table.setSize(area.width, area.height);
        } else if (oldSize.x < area.width) {
            this.table.setSize(area.width, area.height);
            this.updateColumnWidths(width);
        }
    }

    private void updateColumnWidths(int tableWidth) {
        int columnsWithoutWidth = 0;
        int unusedWidth = tableWidth - this.firstColumnWidth;
        for (ITableColumn iTableColumn : this.tableDTO.getColdefs()) {
            ITableColumn cDTO = iTableColumn;
            if (cDTO.getWidth() == null || cDTO.getWidth().isEmpty() || "*".equals(cDTO.getWidth())) {
                ++columnsWithoutWidth;
                continue;
            }
            unusedWidth -= Integer.parseInt(cDTO.getWidth());
        }
        int defaultColumnWidth = columnsWithoutWidth != 0 ? unusedWidth / columnsWithoutWidth : 0;
        this.table.getColumn(0).setWidth(this.firstColumnWidth);
        List<? extends ITableColumn> list = this.tableDTO.getColdefs();
        for (int i = 0; i < list.size(); ++i) {
            ITableColumn cDTO = list.get(i);
            if (cDTO.getWidth() != null && !cDTO.getWidth().isEmpty() && !"*".equals(cDTO.getWidth())) {
                this.table.getColumn(i + 1).setWidth(Integer.parseInt(cDTO.getWidth()));
                continue;
            }
            this.table.getColumn(i + 1).setWidth(defaultColumnWidth);
        }
    }

    private class SortListener
    extends SelectionAdapter {
        private SortListener() {
        }

        public void widgetSelected(SelectionEvent ev) {
            TaxmeTableColumn column = (TaxmeTableColumn)ev.widget;
            if (column != TablePart.this.table.getSortColumn()) {
                TablePart.this.table.setSortDirection(0);
            }
            TablePart.this.table.setSortColumn(column);
            if (TablePart.this.table.getSortDirection() == 128) {
                TablePart.this.table.setSortDirection(1024);
            } else {
                TablePart.this.table.setSortDirection(128);
            }
            String tableDmk = EngineUtil.removeTableIndices((String)TablePart.this.tableDTO.getTableDmk());
            TableSort tableSort = new TableSort(TablePart.this.table.getSortDirection() == 128, TablePart.this.table.indexOf(TablePart.this.table.getSortColumn()));
            TablePart.this.tableSorts.put(tableDmk, tableSort);
            if (TablePart.this.tableViewer != null) {
                TablePart.this.tableViewer.getTable().setRedraw(false);
                TablePart.this.tableViewer.refresh();
                TablePart.this.tableViewer.getTable().setRedraw(true);
            } else {
                TablePart.this.table.setRedraw(false);
                TablePart.this.init(TablePart.this.tableDTO);
                TablePart.this.table.setRedraw(true);
            }
        }
    }

    private static class ScrollToVisibleListener
    extends SelectionAdapter {
        private ScrollToVisibleListener() {
        }

        public void widgetSelected(SelectionEvent ev) {
            TableItem ti = (TableItem)ev.item;
            if (ti == null) {
                return;
            }
            Rectangle rect = ti.getBounds(0);
            ScrolledComposite sc = null;
            for (Table c = ti.getParent(); c != null && sc == null; c = c.getParent()) {
                Composite parent = c.getParent();
                if (parent != null && parent instanceof ScrolledComposite) {
                    sc = (ScrolledComposite)parent;
                    continue;
                }
                Point loc = c.getLocation();
                rect.y += loc.y;
                rect.x += loc.x;
            }
            GuiUtil.scrollToVisible(sc, rect);
        }
    }
}

