/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.wizard;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.wizard.AWizardItem;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WTableColumn;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WTableRow;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.presentation.common.util.TableSortHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WTableItem
extends AWizardItem
implements ITableItem {
    private final WizardDisplayInfoDTO.TableItemDTO item;
    private final List<WTableColumn> coldefs;
    private List<WTableRow> rows;
    private ITableRow emptyRow = null;

    public WTableItem(WizardDisplayInfoDTO.TableItemDTO item) {
        this.item = item;
        this.coldefs = new ArrayList<WTableColumn>();
        for (WizardDisplayInfoDTO.ColDefItemDTO element : item.getColdefs()) {
            if (12 == element.getState() || 11 == element.getState()) continue;
            this.coldefs.add(new WTableColumn(element));
        }
        this.initRows();
    }

    private void initRows() {
        this.rows = new ArrayList<WTableRow>();
        if (this.item.getRows() != null) {
            for (Object element2 : this.item.getRows()) {
                WizardDisplayInfoDTO.RowItemDTO element = (WizardDisplayInfoDTO.RowItemDTO)element2;
                if (12 == element.getState() || 11 == element.getState()) continue;
                this.rows.add(new WTableRow(element, false, this));
            }
        }
        if (this.item.getEmptyRow() != null) {
            this.emptyRow = new WTableRow(this.item.getEmptyRow(), true, this);
        }
    }

    @Override
    public int getColspan() {
        return this.item.getColspan();
    }

    @Override
    public int getRowspan() {
        return this.item.getRowspan();
    }

    @Override
    public @Nullable String getTitleKey() {
        return this.item.getHeader();
    }

    @Override
    public String getAlign() {
        return this.item.getAlign();
    }

    @Override
    public boolean isEditable() {
        return this.item.isEditable();
    }

    @Override
    public @NonNull DisplayItemUniqueID getUID() {
        return this.item.getUniqueItemIdentifier();
    }

    public List<WTableColumn> getColdefs() {
        return this.coldefs;
    }

    public List<WTableRow> getRows() {
        return this.rows;
    }

    @Override
    public ITableRow getEmptyRow() {
        return this.emptyRow;
    }

    @Override
    public boolean isFirstColumnStatus() {
        return true;
    }

    @Override
    public int getRowHeigth() {
        return OsSupport.isMacOs() ? 22 : 0;
    }

    @Override
    public boolean isVariableHeight() {
        return true;
    }

    @Override
    public boolean isHeaderVisible() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.item.getState() != 11;
    }

    public WizardDisplayInfoDTO.TableItemDTO getItem() {
        return this.item;
    }

    @Override
    public boolean isEnhanced() {
        return false;
    }

    @Override
    public String getTableDmk() {
        return this.item.getDataModelKey();
    }

    @Override
    public void applySorts(Map<String, TableSort> tableSorts) {
        TaxmeController ctrl = TaxmeController.getInstance();
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.getTableDmk());
        TableSortHelper.sortTable((WizardDisplayInfoDTO.TableItemDTO)this.item, (AbstractConverter.ConverterContext)ctx, tableSorts);
        this.initRows();
    }

    @Override
    public boolean isReadOnly() {
        return this.item.isReadOnly();
    }

    @Override
    public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    WizardDisplayInfoDTO.LabelAddOnDTO> getLabelAddOns() {
        return this.item.getLabelAddOns();
    }

    @Override
    public boolean getOnlyShowVisualizeButton() {
        return this.item.getOnlyShowVisualizeButton();
    }
}

