/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.parser;

import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class HelpContentHandler
implements ContentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HelpContentHandler.class);
    private static HelpModel helpModel = new HelpModel();
    private HelpRoot currentRoot = null;
    private ArrayList<HelpItem> helpItems = new ArrayList();
    private static HelpContentHandler current = null;

    public static HelpContentHandler getInstance() {
        if (current == null) {
            return new HelpContentHandler();
        }
        return current;
    }

    private HelpContentHandler() {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("helpRoot")) {
            helpModel.addRootItem(this.currentRoot);
            this.currentRoot = null;
        } else if (qName.equals("helpItem")) {
            int nbrOfItems = this.helpItems.size();
            HelpItem lastItem = this.helpItems.get(nbrOfItems - 1);
            if (nbrOfItems <= 1) {
                lastItem.setParent(this.currentRoot);
                this.currentRoot.addItem(lastItem);
            } else {
                HelpItem parentOfLastItem = this.helpItems.get(nbrOfItems - 2);
                lastItem.setParent(parentOfLastItem);
                parentOfLastItem.addItem(lastItem);
            }
            this.helpItems.remove(nbrOfItems - 1);
        } else if (qName.equals("help")) {
            LOG.debug("Parsing terminated");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("help")) {
            helpModel.setId(atts.getValue("id"));
            helpModel.setNameFR(atts.getValue("nameFR"));
            helpModel.setNameDE(atts.getValue("nameDE"));
        } else if (qName.equals("helpRoot")) {
            this.currentRoot = new HelpRoot();
            this.currentRoot.setId(atts.getValue("id"));
            this.currentRoot.setNameFR(atts.getValue("nameFR"));
            this.currentRoot.setNameDE(atts.getValue("nameDE"));
        } else if (qName.equals("helpItem")) {
            HelpItem item = new HelpItem();
            item.setId(atts.getValue("id"));
            item.setNameFR(atts.getValue("nameFR"));
            item.setNameDE(atts.getValue("nameDE"));
            String topic = atts.getValue("topic");
            if (topic == null) {
                topic = "";
            }
            item.setTopic(topic);
            this.helpItems.add(item);
        }
    }

    public HelpModel getHelpModel() {
        return helpModel;
    }
}

