/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.gui.model;

import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpTreeLabelProvider
implements ILabelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HelpTreeLabelProvider.class);
    public static final int EXPANDED = 1;
    public static final int COLLAPSED = 2;
    private Image help = null;
    private Image helpOpened = null;
    private Image helpClosed = null;
    private List<ILabelProviderListener> listeners;
    private List<Object> expandeds;
    private List<Object> collapseds;

    public HelpTreeLabelProvider() {
        try {
            this.listeners = new ArrayList<ILabelProviderListener>();
            this.expandeds = new ArrayList<Object>();
            this.collapseds = new ArrayList<Object>();
            this.help = GuiUtil.getImageRegistry().get("icon.help.tree.leaf");
            this.helpClosed = GuiUtil.getImageRegistry().get("icon.help.tree.closed");
            this.helpOpened = GuiUtil.getImageRegistry().get("icon.help.tree.opened");
        }
        catch (Exception e) {
            LOG.error("Error constructing HelpTreeLabelProvider: ", (Throwable)e);
        }
    }

    public Image getImage(Object element) {
        HelpItem item = (HelpItem)element;
        if (!item.getItems().isEmpty()) {
            for (Object expanded : this.expandeds) {
                if (item != expanded) continue;
                return this.helpOpened;
            }
            for (Object collapsed : this.collapseds) {
                if (item != collapsed) continue;
                return this.helpClosed;
            }
            return this.helpClosed;
        }
        return this.help;
    }

    public String getText(Object element) {
        return ((HelpItem)element).getName();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void changeSomeState(Object element, int type) {
        int i;
        if (type == 1) {
            this.expandeds.add(element);
            for (i = 0; i < this.collapseds.size(); ++i) {
                if (element != this.collapseds.get(i)) continue;
                this.collapseds.remove(element);
            }
        } else if (type == 2) {
            this.collapseds.add(element);
            for (i = 0; i < this.expandeds.size(); ++i) {
                if (element != this.expandeds.get(i)) continue;
                this.expandeds.remove(element);
            }
        }
        LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(labelProviderChangedEvent);
        }
    }
}

