/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpertNavigationPart
extends ScrolledComposite {
    private static final Logger LOG = LoggerFactory.getLogger(ExpertNavigationPart.class);
    private final ImageRegistry imageRegistry = new ImageRegistry();
    private final ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private final Composite data = new Composite((Composite)this, 0);

    public ExpertNavigationPart(Composite parent) {
        super(parent, 2816);
        this.setContent((Control)this.data);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.data.setLayout((Layout)gl);
        this.data.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
    }

    public void setContent(ExpertDisplayInfoDTO expDisplay) {
        List<ExpertDisplayInfoDTO.NavigationDTO> newItems = expDisplay.getNavigationItems();
        if (newItems == null) {
            newItems = Collections.emptyList();
        }
        this.setRedraw(false);
        this.controlReuseUtil.start();
        try {
            this.createNavGroup(newItems, this.data, 0);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            LOG.error("Error setting content on creating nav group: ", (Throwable)e);
        }
        this.controlReuseUtil.end();
        this.data.layout();
        this.setMinSize(this.data.computeSize(-1, -1));
        this.setRedraw(true);
    }

    private void createNavGroup(List<ExpertDisplayInfoDTO.NavigationDTO> navItems, Composite parent, int level) {
        for (int i = 0; i < navItems.size(); ++i) {
            GridLayout gl;
            ExpertDisplayInfoDTO.NavigationDTO nav = navItems.get(i);
            if (nav.getState() == 12 || nav.isExtraForm()) continue;
            Composite c = (Composite)this.controlReuseUtil.getControl(nav.getUniqueItemIdentifier());
            if (c == null) {
                c = new Composite(parent, 2048);
                this.controlReuseUtil.addControl(nav.getUniqueItemIdentifier(), (Control)c);
                gl = new GridLayout(1, true);
                gl.horizontalSpacing = 0;
                gl.verticalSpacing = 0;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                gl.marginLeft = 0;
                gl.marginRight = 0;
                c.setLayout((Layout)gl);
                c.setLayoutData((Object)new GridData(768));
                final TaxmeButton button = new TaxmeButton(c, 2);
                button.setAlignment(0x1000000);
                button.setLayoutData(new GridData(768));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent ev) {
                        button.setSelection(true);
                        ExpertNavigationPart.openForm((String)button.getData());
                    }
                });
            }
            gl = (GridLayout)c.getLayout();
            gl.marginLeft = navItems.size() > 1 ? 6 : 0;
            c.setLayout((Layout)gl);
            TaxmeController ctrl = TaxmeController.getInstance();
            TaxmeButton button = (TaxmeButton)c.getChildren()[0];
            button.setData(nav.getAccessKey());
            button.setSelection(nav.isSelected());
            button.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
            if (nav.getIconName() == null || nav.getIconName().isEmpty()) {
                String msg = ctrl.getLocalizationHelper().translate("nav.expert." + nav.getFormName(), new Object[]{String.valueOf(i + 1)});
                button.setText(msg);
                button.setFont(GuiUtil.getFontRegistry().get("font.navigation"));
            } else {
                Image img = this.readImage(nav.getIconName());
                if (img != null) {
                    button.setImage(img);
                }
            }
            if (nav.getDescriptionKey() != null) {
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), nav.getTableEntryDMK());
                String msg = ExpertDisplayInfoDTO.getLabelText((String)nav.getDescriptionKey(), (List)nav.getDesciptionAddOns(), (AbstractConverter.ConverterContext)ctx);
                msg = StringUtil.htmlToText((String)msg);
                button.setToolTipText(msg);
            }
            String color = null;
            switch (nav.getState()) {
                case 3: {
                    color = GuiUtil.COLOR_MISSING_VALUE;
                    break;
                }
                case 1: {
                    color = GuiUtil.COLOR_GREEN;
                    break;
                }
                case 2: {
                    color = GuiUtil.COLOR_YELLOW;
                    break;
                }
                case 4: {
                    color = GuiUtil.COLOR_RED;
                    break;
                }
            }
            if (color != null) {
                c.setBackground(GuiUtil.getColorRegistry().get(color));
            }
            List subItems = nav.getSubItems();
            if ((level == 0 || nav.isSelected()) && subItems != null && !subItems.isEmpty()) {
                this.createNavGroup(subItems, c, level + 1);
            }
            c.layout();
        }
    }

    private static void openForm(final String accessKey) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TaxmeController ctrl = TaxmeController.getInstance();
                if (ctrl.getFormAccessKey() != null) {
                    ValidateAction validateAction = new ValidateAction();
                    validateAction.execute(ctrl.getExpertDisplayInfoDTO());
                    if (ctrl.hasCurrentExpertFormNewMessages()) {
                        return;
                    }
                }
                ctrl.setFormAccessKey(accessKey);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    private Image readImage(String name) {
        return GuiUtil.getImage(TaxmeController.getInstance().getFormSource(), name, this.imageRegistry);
    }
}

