/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintableActionBase;
import ch.dvbern.tax.common.presentation.cd.action.WizardMultiPrintAction;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends TaxmeTitleAreaDialog {
    protected final List<Button> buttonsEinzeln = new ArrayList<Button>();
    protected final List<Button> buttonsAlle = new ArrayList<Button>();
    private static final int MARGIN_LEFT = 20;
    private static volatile boolean allowMultipleWizardPrint = false;
    private PrintableAction printAction = null;

    public PrintDialog(Shell parentShell) {
        super(parentShell);
    }

    public synchronized PrintableAction getPrintAction() {
        return this.printAction;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.shell.print.dialog", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.print.dialog", new Object[0]));
        this.setMessage(Messages.configurableTranslate("label.print.message", new Object[0]));
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        Label labelEinzeln = new Label(panel, 64);
        GridData gd = new GridData();
        gd.widthHint = 500;
        labelEinzeln.setLayoutData((Object)gd);
        labelEinzeln.setText(Messages.configurableTranslate("label.print.einzelformulare", (Control)labelEinzeln, new Object[0]));
        this.buttonsEinzeln.clear();
        List navItems = session.getExpertNavigationItems();
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : navItems) {
            GridData gd2 = new GridData();
            gd2.horizontalIndent = 20;
            if (navigationDTO.isExtraForm() || navigationDTO.getPrintState() == 12) continue;
            Button buttonEinzeln = new Button(panel, 32);
            buttonEinzeln.setLayoutData((Object)gd2);
            buttonEinzeln.setData((Object)navigationDTO);
            buttonEinzeln.setText(Messages.configurableTranslate("nav.expert." + navigationDTO.getFormName(), (Control)buttonEinzeln, new Object[0]));
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                buttonEinzeln.setEnabled(true);
            } else {
                buttonEinzeln.setEnabled(false);
            }
            this.buttonsEinzeln.add(buttonEinzeln);
        }
        Label labelAlles = new Label(panel, 64);
        GridData gdAlles = new GridData();
        gdAlles.widthHint = 500;
        labelAlles.setLayoutData((Object)gdAlles);
        labelAlles.setText(Messages.configurableTranslate("label.print.alleformulare", (Control)labelAlles, new Object[0]));
        int stateStek = session.getDataModelState();
        if (stateStek != 1 && stateStek != 2) {
            Label labelWarnung = new Label(panel, 64);
            GridData gdWarnung = new GridData();
            gdWarnung.widthHint = 500;
            labelWarnung.setLayoutData((Object)gdWarnung);
            labelWarnung.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            labelWarnung.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            labelWarnung.setText(Messages.configurableTranslate("label.print.warnung.nicht.gruen", (Control)labelWarnung, new Object[0]));
        }
        this.buttonsAlle.clear();
        ActionRegistry reg = ActionRegistry.getInstance();
        for (PrintableActionBase action : reg.getPrintActions()) {
            GridData gd4 = new GridData();
            gd4.horizontalIndent = 20;
            Button buttonAlles = new Button(panel, 32);
            if (stateStek == 1 || stateStek == 2) {
                buttonAlles.setEnabled(true);
            } else {
                buttonAlles.setEnabled(false);
            }
            buttonAlles.setLayoutData((Object)gd4);
            buttonAlles.setText(action.getText());
            buttonAlles.addSelectionListener((SelectionListener)new PrintAllSelectionListener());
            buttonAlles.setData((Object)action);
            this.buttonsAlle.add(buttonAlles);
        }
        return panel;
    }

    protected synchronized void okPressed() {
        this.printAction = this.buildPrintAction();
        super.okPressed();
    }

    protected PrintableAction buildPrintAction() {
        List<FormKey> checked;
        if (allowMultipleWizardPrint) {
            ArrayList docsForMultiPrint = new ArrayList();
            for (Button button : this.buttonsAlle) {
                if (!button.getSelection() || !(button.getData() instanceof PrintableAction)) continue;
                PrintableAction action = (PrintableAction)button.getData();
                docsForMultiPrint.addAll(action.getFormKeys());
            }
            if (!docsForMultiPrint.isEmpty()) {
                return new WizardMultiPrintAction(docsForMultiPrint);
            }
        } else {
            for (Button button : this.buttonsAlle) {
                if (!button.getSelection() || !(button.getData() instanceof PrintableAction)) continue;
                return (PrintableAction)button.getData();
            }
        }
        if (!(checked = this.getChecked()).isEmpty()) {
            PrintableAction printAction = new PrintableAction(){

                @Override
                public List<FormKey> getFormKeys() {
                    return checked;
                }

                @Override
                public FormRendererConfiguration getConfiguration() {
                    return new FormRendererConfiguration().withCopyWatermark(true);
                }
            };
            return printAction;
        }
        return null;
    }

    private List<FormKey> getChecked() {
        ArrayList<FormKey> checked = new ArrayList<FormKey>();
        for (Button button : this.buttonsEinzeln) {
            if (!button.getSelection()) continue;
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)button.getData();
            this.addSubItems(navigationDTO, checked);
        }
        return checked;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List<FormKey> items) {
        if (navigationDTO.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO childDTO : navigationDTO.getSubItems()) {
                if (childDTO.getPrintState() == 12) continue;
                this.addSubItems(childDTO, items);
            }
        } else {
            FormKey key = new FormKey(navigationDTO.getAccessKey(), Mode.EXPERT);
            items.add(key);
        }
    }

    private boolean canShowButtonsEinzeln() {
        for (Button button : this.buttonsAlle) {
            if (!button.getSelection()) continue;
            return false;
        }
        return true;
    }

    protected void enableButtonsEinzeln() {
        for (Button button : this.buttonsEinzeln) {
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)button.getData();
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                button.setEnabled(true);
                continue;
            }
            button.setEnabled(false);
        }
        Iterator<Button> iterator = this.buttonsAlle.iterator();
        while (iterator.hasNext()) {
            Button element;
            Button button = element = iterator.next();
            button.setEnabled(true);
        }
    }

    protected void disableButtonsEinzeln() {
        for (Button button : this.buttonsEinzeln) {
            button.setSelection(false);
            button.setEnabled(false);
        }
    }

    public static void setAllowMultipleWizardPrint(boolean newAllowMultipleWizardPrint) {
        allowMultipleWizardPrint = newAllowMultipleWizardPrint;
    }

    protected class PrintAllSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent ev) {
            if (allowMultipleWizardPrint) {
                if (!PrintDialog.this.canShowButtonsEinzeln()) {
                    PrintDialog.this.disableButtonsEinzeln();
                } else {
                    PrintDialog.this.enableButtonsEinzeln();
                }
            } else if (((Button)ev.getSource()).getSelection()) {
                PrintDialog.this.disableButtonsEinzeln();
                Iterator<Button> iterator = PrintDialog.this.buttonsAlle.iterator();
                while (iterator.hasNext()) {
                    Button element;
                    Button button = element = iterator.next();
                    if (ev.getSource() == button) continue;
                    button.setEnabled(false);
                }
            } else {
                PrintDialog.this.enableButtonsEinzeln();
            }
        }
    }
}

