/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.expert;

import ch.dvbern.tax.common.presentation.cd.builders.common.ValueBuilder;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Control;

public class EValueBuilder
extends ValueBuilder {
    private ExpertDisplayInfoDTO.ValueItemDTO valueDTO;
    private List<Control> tabOrder;
    private List<Control> controls;

    public void init(ExpertDisplayInfoDTO.ValueItemDTO valueDTO) {
        this.valueDTO = valueDTO;
        this.tabOrder = null;
        this.controls = null;
    }

    @Override
    public void createControl() {
        this.controls = this.createValuePart(this.valueDTO);
        this.tabOrder = new ArrayList<Control>();
        for (Control ctrl : this.controls) {
            if (this.valueDTO.isReadonly()) continue;
            this.tabOrder.add(ctrl);
        }
    }

    private List<Control> createValuePart(ExpertDisplayInfoDTO.ValueItemDTO valueItemDTO) {
        if (valueItemDTO.getModelItem() != null && valueItemDTO.getModelItem().getState() == 12) {
            return Collections.emptyList();
        }
        Map valuePositions = valueItemDTO.getValuePositions();
        if (valuePositions == null || valuePositions.isEmpty()) {
            EValueItem item = new EValueItem(valueItemDTO, null, null, this.zoom, true);
            Control control = this.createValuePart(item);
            return Collections.singletonList(control);
        }
        ArrayList<Control> controls = new ArrayList<Control>();
        for (Map.Entry entry : valuePositions.entrySet()) {
            EValueItem item = new EValueItem(valueItemDTO, (ExpertDisplayInfoDTO.ValuePositionDTO)entry.getValue(), entry.getKey(), this.zoom, true);
            Control control = this.createValuePart(item);
            controls.add(control);
        }
        return controls;
    }

    @Override
    public List<? extends Control> getTabOrder() {
        return this.tabOrder;
    }

    @Override
    public Control getControl() {
        if (this.controls == null || this.controls.isEmpty()) {
            return null;
        }
        return this.controls.get(0);
    }
}

