/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.common;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.builders.ControlBuilderFactory;
import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.items.IItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class EnhancedTableRowBuilder
extends AControlBuilder {
    private ITableRow rowDTO;
    private TaxmeComposite control;
    private final ControlBuilderFactory controlBuilderFactory = ControlBuilderFactory.getInstance();
    private final Director director = new Director();
    private ControlPanelHolder controlPanelHolder;

    public void init(ITableRow row) {
        this.rowDTO = row;
        this.control = null;
        this.controlPanelHolder = null;
    }

    @Override
    public void createControl() {
        ArrayList<? extends Control> tabOrder = new ArrayList<Control>();
        DisplayItemUniqueID id = this.rowDTO.getUID().appendLocal(".enhanced.composite");
        this.control = (TaxmeComposite)this.controlReuseUtil.getControl(id);
        if (this.control == null) {
            this.control = new TaxmeComposite(this.parent, 0);
            this.controlReuseUtil.addControl(id, (Control)this.control);
            this.control.setBackground(this.control.getDisplay().getSystemColor(1));
            this.control.setBackgroundMode(1);
            this.control.setLayoutData(new GridData(1808));
        }
        this.controlPanelHolder = new ControlPanelHolder(this.control, this.controlReuseUtil, this.zoom);
        for (Object element : this.rowDTO.getCells()) {
            IItem item;
            IControlBuilder builder;
            if (!(element instanceof IItem) || (builder = this.controlBuilderFactory.createBuilder(item = (IItem)element)) == null) continue;
            this.director.init(builder, this.controlPanelHolder);
            this.director.createControl();
            tabOrder.addAll(builder.getTabOrder());
        }
        this.control.setTabList(tabOrder.toArray(new Control[tabOrder.size()]));
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public List<TaxmeComposite> getTabOrder() {
        return Collections.singletonList(this.control);
    }
}

