/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.dialog.PrintDialog;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.Collections;
import java.util.List;

public class FilePrintAction
extends ActionBase
implements ButtonCommand {
    public FilePrintAction() {
        this("menu.file.print", "Ctrl+P", "icon.menu.file.print");
    }

    public FilePrintAction(String name, String shortcut, String iconName) {
        super(name, shortcut, iconName);
    }

    public void run() {
        List<FormKey> keys;
        PrintableAction printAction;
        TaxmeController ctrl = TaxmeController.getInstance();
        if (ctrl.getMode() == Mode.EXPERT) {
            ctrl.getTmoCdSession().touchCompleteModel();
            ctrl.update();
        }
        if ((printAction = this.getPrintAction()) != null && (keys = printAction.getFormKeys()) != null && !keys.isEmpty()) {
            PrintRequest printRequest = PrintUtilCD.newPrintRequest().withFormKeys(keys).withConfiguration(printAction.getConfiguration());
            PrintUtilCD.printForms(printRequest);
        }
    }

    protected PrintableAction getPrintAction() {
        ExpertDisplayInfoDTO.NavigationDTO navigationDTO;
        List navItems = TaxmeController.getInstance().getTmoCdSession().getExpertNavigationItems();
        if (navItems.size() == 1 && ((navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)navItems.get(0)).getState() == 1 || navigationDTO.getState() == 2)) {
            final FormKey key = new FormKey(navigationDTO.getAccessKey(), Mode.EXPERT);
            PrintableAction printAction = new PrintableAction(){

                @Override
                public List<FormKey> getFormKeys() {
                    return Collections.singletonList(key);
                }

                @Override
                public FormRendererConfiguration getConfiguration() {
                    return new FormRendererConfiguration();
                }
            };
            return printAction;
        }
        PrintDialog dlg = new PrintDialog(TaxmeController.getInstance().getShell());
        dlg.open();
        return dlg.getPrintAction();
    }

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.run();
    }
}

