/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class GuiEditorEntry {
    private static final String SEPARATOR = ":";
    private Point2D.Float position;
    private Point2D.Float size;
    private final String form;
    private final String key;
    private final String optionPosition;
    private final Type type;

    public GuiEditorEntry(Point2D.Float position, Point2D.Float size, String form, Type type, String key, String optionPositon) {
        this.position = position;
        this.size = size;
        this.form = form;
        this.type = type;
        this.key = key;
        this.optionPosition = optionPositon;
    }

    public void setPosition(Point2D.Float position) {
        this.position = position;
    }

    public void setSize(Point2D.Float size) {
        this.size = size;
    }

    public String printXPath() {
        StringBuilder xPathAndSettings = new StringBuilder("//e-form[@name=\"" + this.form + "\"]/");
        if (this.type == Type.E_LABEL) {
            xPathAndSettings.append(Type.E_LABEL.toString());
            xPathAndSettings.append("[@key=\"");
        } else {
            xPathAndSettings.append(Type.E_VALUE.toString());
            xPathAndSettings.append("[@value=\"");
        }
        xPathAndSettings.append(this.key).append("\"]");
        if (this.type == Type.E_VALUE_POS) {
            xPathAndSettings.append("/").append(this.type.toString());
            xPathAndSettings.append("[@value=\"").append(this.optionPosition).append("\"]");
        }
        xPathAndSettings.append(SEPARATOR);
        try {
            xPathAndSettings.append("x=\"").append(this.render(this.position.x));
            xPathAndSettings.append("\" y=\"").append(this.render(this.position.y));
            xPathAndSettings.append("\" width=\"").append(this.render(this.size.x));
            xPathAndSettings.append("\" height=\"").append(this.render(this.size.y)).append("\"");
        }
        catch (NullPointerException e) {
            xPathAndSettings.append("\" keine Werte");
        }
        return xPathAndSettings.toString();
    }

    private String render(float value) {
        DecimalFormat nf = new DecimalFormat("0.#");
        return nf.format(value);
    }

    public static enum Type {
        E_VALUE("e-value"),
        E_VALUE_POS("e-value-pos"),
        E_LABEL("e-label");

        private final String tag;

        private Type(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }
}

