/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.ObjectConstructor;
import ch.dvbern.lib.resource.construct.xml.ClassLoaderResourceLocator;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ResourceChangeListener;
import ch.dvbern.lib.resource.construct.xml.ResourceChangedEvent;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLObjectConstructor
implements ObjectConstructor,
ResourceChangeListener {
    @Nonnull
    private final Map<String, Object> cachedObjects = new HashMap<String, Object>();
    @Nonnull
    private final ParserFactory factory;

    public XMLObjectConstructor() {
        this(new ParserFactory(new ClassLoaderResourceLocator()));
    }

    public XMLObjectConstructor(@Nonnull ParserFactory factory) {
        this.factory = factory;
        factory.getResourceLocator().addResourceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Object construct(@Nonnull String objectId, boolean newInstance) throws ConstructionException {
        Map<String, Object> map;
        Object obj = null;
        if (!newInstance) {
            map = this.cachedObjects;
            synchronized (map) {
                obj = this.cachedObjects.get(objectId);
            }
        }
        if (obj == null) {
            obj = this.parse(objectId, this.factory);
            map = this.cachedObjects;
            synchronized (map) {
                this.cachedObjects.put(objectId, obj);
            }
        }
        return obj;
    }

    @Nonnull
    private Object parse(@Nonnull String objectId, @Nonnull ParserFactory parserFactory) throws ConstructionException {
        try {
            InputStream ins = parserFactory.getResourceLocator().getResourceAsStream(objectId);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(ins);
            Element root = new Element(doc.getDocumentElement());
            Object value = parserFactory.getParser(root.getNodeName()).parse(root, parserFactory).getObject();
            if (value == null) {
                throw new ConstructionException("Could not construct root, parser returned null");
            }
            return value;
        }
        catch (SAXException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (IOException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ConstructionException("no parser found for root-element", ex);
        }
        catch (ElementParserException ex) {
            throw new ConstructionException("root-element could NOT have been parsed", ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new ConstructionException("resource with id=" + objectId + " not found", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceChanged(@Nonnull ResourceChangedEvent event) {
        String resource = event.getResourceName();
        Map<String, Object> map = this.cachedObjects;
        synchronized (map) {
            if (this.cachedObjects.get(resource) != null) {
                this.cachedObjects.remove(resource);
            }
        }
    }

    @Override
    public void resourceRemoved(@Nonnull ResourceChangedEvent event) {
        this.resourceChanged(event);
    }
}

