/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ResourceChangeListener;
import ch.dvbern.lib.resource.construct.xml.ResourceChangedEvent;
import ch.dvbern.lib.resource.construct.xml.ResourceLocator;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathResourceLocator
implements ResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(FilePathResourceLocator.class);
    @Nonnull
    private final String path;
    @Nonnull
    private final HashSet<ResourceChangeListener> listeners;
    @Nonnull
    private final HashSet<File> files;
    @Nonnull
    private final ResourceChecker resourceChecker;

    public FilePathResourceLocator(@Nonnull String path) {
        this(path, 10000L);
    }

    public FilePathResourceLocator(@Nonnull String path, long resChangeCheckPeriod) {
        this.path = path;
        this.listeners = new HashSet();
        this.files = new HashSet();
        this.resourceChecker = new ResourceChecker(resChangeCheckPeriod);
        Thread thread = new Thread(this.resourceChecker);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public InputStream getResourceAsStream(@Nonnull String resourceName) throws ResourceNotFoundException {
        try {
            File file = new File(this.path, resourceName);
            HashSet<File> hashSet = this.files;
            synchronized (hashSet) {
                if (!this.files.contains(file)) {
                    this.files.add(file);
                }
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new ResourceNotFoundException("resource=" + resourceName + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceChangeListener(@Nonnull ResourceChangeListener listener) {
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceChangeListener(@Nonnull ResourceChangeListener listener) {
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceChange(@Nonnull String resource) {
        Set clone;
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            Set tmp;
            clone = tmp = (Set)this.listeners.clone();
        }
        for (ResourceChangeListener listener : clone) {
            try {
                listener.resourceChanged(event);
            }
            catch (RuntimeException ex) {
                LOG.error("Error while notifying listener: " + listener, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceRemoved(@Nonnull String resource) {
        Set clone;
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        HashSet<ResourceChangeListener> hashSet = this.listeners;
        synchronized (hashSet) {
            Set tmp;
            clone = tmp = (Set)this.listeners.clone();
        }
        for (ResourceChangeListener listener : clone) {
            try {
                listener.resourceRemoved(event);
            }
            catch (RuntimeException ex) {
                LOG.error("Error while notifying listener: " + listener, (Throwable)ex);
            }
        }
    }

    public void stopResourceChecker() {
        this.resourceChecker.stopChecker();
    }

    private class ResourceChecker
    implements Runnable {
        private long lastCheck = System.currentTimeMillis();
        private long checkPeriod;
        private boolean run;

        public ResourceChecker(long checkPeriod) {
            this.checkPeriod = checkPeriod;
            this.run = true;
        }

        public void stopChecker() {
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                Set clone;
                long tmpCheck = System.currentTimeMillis();
                HashSet hashSet = FilePathResourceLocator.this.files;
                synchronized (hashSet) {
                    Set tmp;
                    clone = tmp = (Set)FilePathResourceLocator.this.files.clone();
                }
                for (File file : clone) {
                    if (!file.exists()) {
                        FilePathResourceLocator.this.notifyResourceRemoved(file.getName());
                        continue;
                    }
                    if (file.lastModified() < this.lastCheck) continue;
                    FilePathResourceLocator.this.notifyResourceChange(file.getName());
                }
                this.lastCheck = tmpCheck;
                try {
                    Thread.sleep(this.checkPeriod);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted while waiting for checkPeriod of " + this.checkPeriod + "ms", (Throwable)ex);
                }
            }
        }
    }
}

