/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil.readers;

import ch.dvbern.lib.cryptutil.annotations.Nullable;
import ch.dvbern.lib.cryptutil.fileformats.PKCS8PEM;
import ch.dvbern.lib.cryptutil.readers.KeyReader;
import ch.dvbern.lib.cryptutil.readers.ReaderException;
import java.io.InputStream;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;

public class PKCS8PEMKeyReader
implements KeyReader<RSAPrivateKey> {
    private final PKCS8PEM pkcs8PEM = new PKCS8PEM();
    private final InputStream privateKey;
    @Nullable
    private final String keyPassword;

    public PKCS8PEMKeyReader(InputStream privateKey, @Nullable String keyPassword) {
        this.privateKey = Objects.requireNonNull(privateKey);
        this.keyPassword = keyPassword;
    }

    @Override
    public RSAPrivateKey readPrivateKey() {
        try {
            return this.pkcs8PEM.readKeyFromPKCS8EncodedPEM(this.privateKey, this.keyPassword);
        }
        catch (Exception e) {
            throw new ReaderException("Could not read PKCS8EncodedPEM", e);
        }
    }
}

