/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil.readers;

import ch.dvbern.lib.cryptutil.fileformats.PKCS8PEM;
import ch.dvbern.lib.cryptutil.readers.CertReader;
import ch.dvbern.lib.cryptutil.readers.ReaderException;
import java.io.InputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;

public class PKCS8PEMCertReader
implements CertReader<RSAPublicKey> {
    private final PKCS8PEM pkcs8PEM = new PKCS8PEM();
    private final InputStream publicKey;

    public PKCS8PEMCertReader(InputStream publicKey) {
        this.publicKey = Objects.requireNonNull(publicKey);
    }

    @Override
    public RSAPublicKey readPublicKey() throws ReaderException {
        try {
            return this.pkcs8PEM.readCertFromPKCS8EncodedPEM(this.publicKey);
        }
        catch (Exception e) {
            throw new ReaderException("Could not read PKCS8EncodedPEM", e);
        }
    }
}

