/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil.fileformats;

import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;

public final class X509PEM {
    public X509Certificate read(InputStream certificate) {
        Objects.requireNonNull(certificate);
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate cer = (X509Certificate)fact.generateCertificate(certificate);
            return cer;
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Could not build CertificateFactory for X.509???", e);
        }
    }
}

