/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

final class Util {
    private Util() {
    }

    static <E extends Exception> void processFully(InputStream is, int readChunkBufferBytes, CheckedConsumer<byte[], E> processor) throws IOException {
        Objects.requireNonNull(is);
        Objects.requireNonNull(processor);
        assert (readChunkBufferBytes > 0);
        int byteOffset = 0;
        byte[] buffer = new byte[readChunkBufferBytes];
        int bytes = 0;
        while (bytes > -1) {
            byte[] tmp = buffer;
            if (bytes != readChunkBufferBytes) {
                tmp = Arrays.copyOf(buffer, bytes);
            }
            try {
                processor.accept(tmp);
                byteOffset += bytes;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error processing at byte offset: " + byteOffset, e);
            }
            bytes = is.read(buffer);
        }
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

