/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil;

import ch.dvbern.lib.cryptutil.SignatureFailedException;
import ch.dvbern.lib.cryptutil.Util;
import ch.dvbern.lib.cryptutil.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Objects;

public class SignatureEngine {
    private static final int READ_BUFFER_SIZE = 4096;
    private static final String ALGO_SHA256_WITH_RSA = "SHA256withRSA";
    private static final String ALGO_SHA512_WITH_RSA = "SHA512withRSA";

    public boolean supportsSHA256RSA(@Nullable Provider provider) {
        return this.supportsAlgorithm(ALGO_SHA256_WITH_RSA, provider);
    }

    public byte[] signSHA256RSA(PrivateKey privateKey, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        return this.signUsingAlgorithm(privateKey, ALGO_SHA256_WITH_RSA, is, provider);
    }

    public boolean supportsSHA512RSA(@Nullable Provider provider) {
        return this.supportsAlgorithm(ALGO_SHA512_WITH_RSA, provider);
    }

    public byte[] signSHA512RSA(PrivateKey privateKey, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        return this.signUsingAlgorithm(privateKey, ALGO_SHA512_WITH_RSA, is, provider);
    }

    public boolean supportsAlgorithm(String algorithm, @Nullable Provider provider) {
        Objects.requireNonNull(algorithm);
        try {
            this.configureSignature(algorithm, provider);
            return true;
        }
        catch (NoSuchAlgorithmException ignored) {
            return false;
        }
    }

    public byte[] signUsingAlgorithm(PrivateKey privateKey, String algorithm, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(is);
        Objects.requireNonNull(algorithm);
        try {
            Signature privateSignature = this.configureSignature(algorithm, provider);
            privateSignature.initSign(privateKey);
            Util.processFully(is, 4096, privateSignature::update);
            byte[] signature = privateSignature.sign();
            return signature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureFailedException(e);
        }
    }

    public boolean verifySHA256RSA(byte[] referenceSignature, PublicKey publicKey, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        return this.verifyUsingAlgorithm(referenceSignature, publicKey, ALGO_SHA256_WITH_RSA, is, provider);
    }

    public boolean verifySHA512RSA(byte[] referenceSignature, PublicKey publicKey, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        return this.verifyUsingAlgorithm(referenceSignature, publicKey, ALGO_SHA512_WITH_RSA, is, provider);
    }

    public boolean verifyUsingAlgorithm(byte[] referenceSignature, PublicKey publicKey, String algorithm, InputStream is, @Nullable Provider provider) throws SignatureFailedException, IOException {
        Objects.requireNonNull(referenceSignature);
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(is);
        try {
            Signature privateSignature = this.configureSignature(algorithm, provider);
            privateSignature.initVerify(publicKey);
            Util.processFully(is, 4096, privateSignature::update);
            boolean verified = privateSignature.verify(referenceSignature);
            return verified;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureFailedException(e);
        }
    }

    private Signature configureSignature(String algorithm, @Nullable Provider provider) throws NoSuchAlgorithmException {
        Objects.requireNonNull(algorithm);
        return provider != null ? Signature.getInstance(algorithm, provider) : Signature.getInstance(algorithm);
    }
}

