/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.lang.reflect.Type;
import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    long fixedHandle;
    long redrawWindow;
    long enableWindow;
    long provider;
    long redrawSurface;
    long enableSurface;
    int drawCount;
    int backgroundAlpha = 255;
    long dragGesture;
    long zoomGesture;
    long rotateGesture;
    long panGesture;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    long eventRegion;
    long regionHandle;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Control labelRelation;
    String cssBackground;
    String cssForeground = " ";
    boolean drawRegion;
    boolean cachedNoBackground;
    Point lastInput = new Point(0, 0);
    LinkedList<Event> dragDetectionQueue;
    static Callback gestureZoom = new Callback(Control.class, "magnifyProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureRotation = new Callback(Control.class, "rotateProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureSwipe = new Callback(Control.class, "swipeProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureBegin = new Callback(Control.class, "gestureBeginProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
    static Callback gestureEnd = new Callback(Control.class, "gestureEndProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
    static boolean mouseDown;
    boolean dragBegun;
    boolean checkScaleFactor = true;
    boolean autoScale = true;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)22).handle;
    }

    @Override
    void deregister() {
        long imHandle;
        super.deregister();
        if (this.fixedHandle != 0L) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((imHandle = this.imHandle()) != 0L) {
            this.display.removeWidget(imHandle);
        }
    }

    void drawBackground(Control control, long gdkResource, long cr, int x, int y, int width, int height) {
        boolean noBackgroundRegion;
        long cairo = 0L;
        long region = 0L;
        if (GTK.GTK4) {
            cairo = cr;
            if (gdkResource != 0L) {
                cairo_rectangle_int_t regionRect = new cairo_rectangle_int_t();
                int[] fetchedHeight = new int[1];
                int[] fetchedWidth = new int[1];
                if (GTK.GTK4) {
                    this.gdk_surface_get_size(gdkResource, fetchedWidth, fetchedHeight);
                } else {
                    this.gdk_window_get_size(gdkResource, fetchedWidth, fetchedHeight);
                }
                regionRect.x = 0;
                regionRect.y = 0;
                regionRect.width = fetchedWidth[0];
                regionRect.height = fetchedHeight[0];
                region = Cairo.cairo_region_create_rectangle(regionRect);
            }
        } else {
            cairo = cr != 0L ? cr : GDK.gdk_cairo_create(gdkResource);
        }
        boolean bl = noBackgroundRegion = this.drawRegion && this.hooks(9) && this.cachedNoBackground;
        if (cairo == 0L) {
            this.error(2);
        }
        if (region != 0L) {
            GDK.gdk_cairo_region(cairo, region);
            Cairo.cairo_clip(cairo);
        }
        if (control.backgroundImage != null) {
            Point pt = this.display.mapInPixels(this, control, 0, 0);
            Cairo.cairo_translate(cairo, -pt.x, -pt.y);
            x += pt.x;
            y += pt.y;
            long pattern = Cairo.cairo_pattern_create_for_surface(control.backgroundImage.surface);
            if (pattern == 0L) {
                this.error(2);
            }
            Cairo.cairo_pattern_set_extend(pattern, 1);
            if ((this.style & 0x8000000) != 0) {
                double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                Cairo.cairo_pattern_set_matrix(pattern, matrix);
            }
            Cairo.cairo_set_source(cairo, pattern);
            Cairo.cairo_pattern_destroy(pattern);
        } else {
            GdkRGBA rgba = control.getBackgroundGdkRGBA();
            if (noBackgroundRegion) {
                Cairo.cairo_set_source_rgba(cairo, 0.0, 0.0, 0.0, 0.0);
            } else {
                Cairo.cairo_set_source_rgba(cairo, rgba.red, rgba.green, rgba.blue, rgba.alpha);
            }
        }
        Cairo.cairo_rectangle(cairo, x, y, width, height);
        Cairo.cairo_fill(cairo);
        if (!GTK.GTK4 && cairo != cr) {
            Cairo.cairo_destroy(cairo);
        }
    }

    boolean drawGripper(GC gc, int x, int y, int width, int height, boolean vertical) {
        long gdkResource;
        long paintHandle = this.paintHandle();
        long l = gdkResource = GTK.GTK4 ? this.gtk_widget_get_surface(paintHandle) : this.gtk_widget_get_window(paintHandle);
        if (gdkResource == 0L) {
            return false;
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        long context = GTK.gtk_widget_get_style_context(paintHandle);
        GTK.gtk_style_context_save(context);
        GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_PANE_SEPARATOR);
        GTK.gtk_style_context_set_state(context, 0L);
        GTK.gtk_render_handle(context, gc.handle, x, y, width, height);
        GTK.gtk_style_context_restore(context);
        return true;
    }

    void drawWidget(GC gc) {
    }

    void enableWidget(boolean enabled) {
        GTK.gtk_widget_set_sensitive(this.handle, enabled);
    }

    long enterExitHandle() {
        return this.eventHandle();
    }

    long eventHandle() {
        return this.handle;
    }

    long eventWindow() {
        long eventHandle = this.eventHandle();
        GTK.gtk_widget_realize(eventHandle);
        return this.gtk_widget_get_window(eventHandle);
    }

    long eventSurface() {
        long eventHandle = this.eventHandle();
        GTK.gtk_widget_realize(eventHandle);
        return this.gtk_widget_get_surface(eventHandle);
    }

    static int fixGdkEventTypeValues(int eventType) {
        if (GTK.GTK4) {
            switch (eventType) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 9: {
                    return 10;
                }
                case 10: {
                    return 11;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 13;
                }
                case 13: {
                    return 14;
                }
                case 14: {
                    return 15;
                }
            }
        }
        return eventType;
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        long focusHandle = shell.vboxHandle;
        GTK.gtk_widget_set_can_focus(focusHandle, true);
        GTK.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return;
        }
        GTK.gtk_widget_set_can_focus(focusHandle, false);
    }

    void fixStyle() {
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(long handle) {
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
    }

    long focusHandle() {
        return this.handle;
    }

    long fontHandle() {
        return this.handle;
    }

    long gestureHandle() {
        return this.handle;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    @Override
    void hookEvents() {
        long blockHandle;
        long focusHandle = this.focusHandle();
        this.hookKeyboardAndFocusSignals(focusHandle);
        this.hookMouseSignals(this.eventHandle());
        this.hookWidgetSignals(focusHandle);
        this.hookPaintSignals();
        this.connectIMSignals();
        this.setZoomGesture();
        this.setDragGesture();
        this.setRotateGesture();
        long eventHandle = this.eventHandle();
        long l = blockHandle = this.fixedHandle != 0L ? this.fixedHandle : eventHandle;
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            OS.g_signal_connect_closure_by_id(blockHandle, this.display.signalIds[33], 0, this.display.getClosure(34), true);
        }
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            if (focusHandle != eventHandle) {
                OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
        }
    }

    private void hookKeyboardAndFocusSignals(long focusHandle) {
        if (GTK.GTK4) {
            long keyController = GTK.gtk_event_controller_key_new();
            GTK.gtk_event_controller_set_propagation_phase(keyController, 3);
            GTK.gtk_widget_add_controller(focusHandle, keyController);
            OS.g_signal_connect(keyController, OS.key_pressed, this.display.keyPressReleaseProc, 89L);
            OS.g_signal_connect(keyController, OS.key_released, this.display.keyPressReleaseProc, 90L);
            long focusController = GTK.gtk_event_controller_focus_new();
            GTK.gtk_event_controller_set_propagation_phase(focusController, 3);
            GTK.gtk_widget_add_controller(focusHandle, focusController);
            OS.g_signal_connect(focusController, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(focusController, OS.leave, this.display.focusProc, 87L);
        } else {
            int focusMask = 19456;
            GTK.gtk_widget_add_events(focusHandle, focusMask);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[28], 0, this.display.getClosure(28), false);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        }
    }

    private void hookMouseSignals(long eventHandle) {
        long enterExitHandle = this.enterExitHandle();
        if (GTK.GTK4) {
            long clickGesture = GTK.gtk_gesture_click_new();
            GTK.gtk_widget_add_controller(eventHandle, clickGesture);
            OS.g_signal_connect(clickGesture, OS.pressed, this.display.gesturePressReleaseProc, 100L);
            OS.g_signal_connect(clickGesture, OS.released, this.display.gesturePressReleaseProc, 101L);
            long scrollController = GTK.gtk_event_controller_scroll_new(5);
            GTK.gtk_event_controller_set_propagation_phase(scrollController, 3);
            GTK.gtk_widget_add_controller(eventHandle, scrollController);
            OS.g_signal_connect(scrollController, OS.scroll, this.display.enterMotionScrollProc, 92L);
            long motionController = GTK.gtk_event_controller_motion_new();
            GTK.gtk_event_controller_set_propagation_phase(motionController, 3);
            GTK.gtk_widget_add_controller(eventHandle, motionController);
            OS.g_signal_connect(motionController, OS.motion, this.display.enterMotionScrollProc, 97L);
            long enterExitController = GTK.gtk_event_controller_motion_new();
            GTK.gtk_event_controller_set_propagation_phase(enterExitController, 3);
            GTK.gtk_widget_add_controller(enterExitHandle, enterExitController);
            OS.g_signal_connect(enterExitController, OS.enter, this.display.enterMotionScrollProc, 95L);
            OS.g_signal_connect(enterExitController, OS.leave, this.display.leaveProc, 96L);
        } else {
            int eventMask = 10486532;
            GTK.gtk_widget_add_events(eventHandle, eventMask);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[43], 0, this.display.getClosure(43), false);
            int enterExitMask = 12288;
            GTK.gtk_widget_add_events(enterExitHandle, enterExitMask);
            OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
            OS.g_signal_connect_closure_by_id(enterExitHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
        }
    }

    private void hookWidgetSignals(long focusHandle) {
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.getClosure(40), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.getClosure(56), false);
        OS.g_signal_connect_closure_by_id(this.topHandle(), this.display.signalIds[30], 0, this.display.getClosure(30), true);
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[38], 0, this.display.getClosure(38), false);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
            OS.g_signal_connect_closure_by_id(focusHandle, this.display.signalIds[20], 0, this.display.getClosure(20), false);
        }
    }

    private void hookPaintSignals() {
        long paintHandle = this.paintHandle();
        if (GTK.GTK4) {
            long widgetClass = GTK.GTK_WIDGET_GET_CLASS(this.paintHandle());
            GtkWidgetClass widgetClassStruct = new GtkWidgetClass();
            OS.memmove(widgetClassStruct, widgetClass);
            widgetClassStruct.snapshot = this.display.snapshotDrawProc;
            OS.memmove(widgetClass, widgetClassStruct);
        } else {
            int paintMask = 2;
            GTK.gtk_widget_add_events(paintHandle, paintMask);
            OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(19), false);
            OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[48], 0, this.display.getClosure(48), false);
        }
    }

    private void connectIMSignals() {
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            OS.g_signal_connect_closure(imHandle, OS.commit, this.display.getClosure(9), false);
            OS.g_signal_connect_closure(imHandle, OS.preedit_changed, this.display.getClosure(39), false);
        }
    }

    boolean hooksPaint() {
        return this.hooks(9) || this.filters(9);
    }

    @Override
    long hoverProc(long widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        int[] mask = new int[1];
        if (GTK.GTK4) {
            double[] xDouble = new double[1];
            double[] yDouble = new double[1];
            long surface = GTK.gtk_native_get_surface(GTK.gtk_widget_get_native(this.handle));
            this.display.getSurfacePointerPosition(surface, xDouble, yDouble, null);
            x[0] = (int)xDouble[0];
            y[0] = (int)yDouble[0];
        } else {
            this.display.getWindowPointerPosition(0L, x, y, mask);
        }
        if (this.containedInRegion(x[0], y[0])) {
            return 0L;
        }
        this.sendMouseEvent(32, 0, 0, x[0], y[0], false, mask[0]);
        return 0L;
    }

    @Override
    long topHandle() {
        if (this.fixedHandle != 0L) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    long paintHandle() {
        long topHandle = this.topHandle();
        if (GTK.GTK4) {
            return topHandle;
        }
        long paintHandle = this.handle;
        while (paintHandle != topHandle && !this.gtk_widget_get_has_surface_or_window(paintHandle)) {
            paintHandle = GTK.gtk_widget_get_parent(paintHandle);
        }
        return paintHandle;
    }

    @Override
    long paintWindow() {
        long paintHandle = this.paintHandle();
        GTK.gtk_widget_realize(paintHandle);
        if (GTK.GTK4) {
            return this.gtk_widget_get_surface(paintHandle);
        }
        return this.gtk_widget_get_window(paintHandle);
    }

    @Override
    long paintSurface() {
        long paintHandle = this.paintHandle();
        GTK.gtk_widget_realize(paintHandle);
        return this.gtk_widget_get_surface(paintHandle);
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        long topHandle = this.topHandle();
        GTK.gtk_widget_realize(topHandle);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        GTK.gtk_widget_get_preferred_size(topHandle, null, null);
        GTK.gtk_widget_size_allocate(topHandle, allocation);
        GTK.gtk_widget_draw(topHandle, gc.handle);
        return true;
    }

    void printWidget(GC gc, long drawable, int depth, int x, int y) {
        boolean obscured = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        long topHandle = this.topHandle();
        long gdkResource = GTK.GTK4 ? this.gtk_widget_get_surface(topHandle) : this.gtk_widget_get_window(topHandle);
        this.printWindow(true, this, gc, drawable, depth, gdkResource, x, y);
        if (obscured) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean first, Control control, GC gc, long drawable, int depth, long window, int x, int y) {
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    Point computeSizeInPixels(int wHint, int hHint) {
        return this.computeSizeInPixels(wHint, hHint, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index;
            for (index = 0; index < tabList.length && tabList[index] != this; ++index) {
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0 || this.backgroundAlpha == 0) {
                if (mode == 1 || this.backgroundAlpha == 0) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidthInPixels() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    boolean containedInRegion(int x, int y) {
        if (this.drawRegion && this.eventRegion != 0L) {
            return Cairo.cairo_region_contains_point(this.eventRegion, x, y);
        }
        return false;
    }

    @Override
    void createWidget(int index) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.checkBackground();
        if ((this.state & 0x8000) != 0) {
            this.setParentBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        if (!GTK.GTK4) {
            this.setRelations();
        }
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        wHint = DPIUtil.autoScaleUp(wHint);
        hHint = DPIUtil.autoScaleUp(hHint);
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(wHint, hHint, changed));
    }

    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    Point computeNativeSize(long h, int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = hHint;
        if (wHint == -1 && hHint == -1) {
            GtkRequisition requisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(h, null, requisition);
            width = requisition.width;
            height = requisition.height;
        } else if (wHint == -1 || hHint == -1) {
            int[] natural_size = new int[1];
            if (wHint == -1) {
                if (GTK.GTK4) {
                    GTK.gtk_widget_measure(h, 0, height, null, natural_size, null, null);
                } else {
                    GTK.gtk_widget_get_preferred_width_for_height(h, height, null, natural_size);
                }
                width = natural_size[0];
            } else {
                if (GTK.GTK4) {
                    GTK.gtk_widget_measure(h, 1, width, null, natural_size, null, null);
                } else {
                    GTK.gtk_widget_get_preferred_height_for_width(h, width, null, natural_size);
                }
                height = natural_size[0];
            }
        }
        return new Point(width, height);
    }

    void forceResize() {
        long topHandle = this.topHandle();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(topHandle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        if (GTK.GTK4) {
            GTK.gtk_widget_size_allocate(topHandle, allocation, -1);
        } else {
            GTK.gtk_widget_size_allocate(topHandle, allocation);
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        return this._getAccessible();
    }

    Accessible _getAccessible() {
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int height;
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        rect = DPIUtil.autoScaleUp(rect);
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    void setBoundsInPixels(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true);
    }

    void setBoundsInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    void markLayout(boolean changed, boolean all) {
    }

    void moveHandle(int x, int y) {
        long topHandle = this.topHandle();
        long parentHandle = this.parent.parentingHandle();
        OS.swt_fixed_move(parentHandle, topHandle, x, y);
    }

    void resizeHandle(int width, int height) {
        long topHandle = this.topHandle();
        OS.swt_fixed_resize(GTK.gtk_widget_get_parent(topHandle), topHandle, width, height);
        if (topHandle != this.handle) {
            Point sizes = this.resizeCalculationsGTK3(this.handle, width, height);
            width = sizes.x;
            height = sizes.y;
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.handle), this.handle, width, height);
        }
    }

    Point resizeCalculationsGTK3(long widget, int width, int height) {
        Point sizes = new Point(width, height);
        GtkRequisition minimumSize = new GtkRequisition();
        GtkRequisition naturalSize = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(widget, minimumSize, naturalSize);
        int smallestWidth = Math.min(minimumSize.width, naturalSize.width);
        int smallestHeight = Math.min(minimumSize.height, naturalSize.height);
        sizes.x = width - (smallestWidth - width) < 0 ? smallestWidth : width;
        sizes.y = height - (smallestHeight - height) < 0 ? smallestHeight : height;
        return sizes;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int oldX;
        width = Math.min(width, Short.MAX_VALUE);
        height = Math.min(height, Short.MAX_VALUE);
        long topHandle = this.topHandle();
        boolean sendMove = move;
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        if ((this.parent.style & 0x8000000) != 0) {
            int clientWidth = this.parent.getClientWidth();
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            oldX = clientWidth - oldWidth - allocation.x;
            if (move) {
                sendMove &= x != oldX;
                x = clientWidth - (resize ? width : oldWidth) - x;
            } else {
                move = true;
                x = clientWidth - (resize ? width : oldWidth) - oldX;
                y = allocation.y;
            }
        }
        boolean sameOrigin = true;
        boolean sameExtent = true;
        if (move) {
            oldX = allocation.x;
            int oldY = allocation.y;
            boolean bl = sameOrigin = x == oldX && y == oldY;
            if (!sameOrigin) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_move(this.enableWindow, x, y);
                }
                this.moveHandle(x, y);
            }
        }
        int clientWidth = 0;
        if (resize) {
            int oldWidth = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int oldHeight = (this.state & 0x400) != 0 ? 0 : allocation.height;
            boolean bl = sameExtent = width == oldWidth && height == oldHeight;
            if (!sameExtent && (this.style & 0x8000000) != 0) {
                clientWidth = this.getClientWidth();
            }
            if (!(sameExtent || width == 0 && height == 0)) {
                int newWidth = Math.max(1, width);
                int newHeight = Math.max(1, height);
                if (!GTK.GTK4) {
                    if (this.redrawWindow != 0L) {
                        GDK.gdk_window_resize(this.redrawWindow, newWidth, newHeight);
                    }
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_resize(this.enableWindow, newWidth, newHeight);
                    }
                }
                this.resizeHandle(newWidth, newHeight);
            }
        }
        if (!sameOrigin || !sameExtent) {
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(topHandle, requisition);
            if (move) {
                allocation.x = x;
                allocation.y = y;
            }
            if (resize) {
                allocation.width = width;
                allocation.height = height;
            }
            if (!GTK.gtk_widget_get_visible(topHandle)) {
                Control focusControl = this.display.getFocusControl();
                GTK.gtk_widget_show(topHandle);
                this.gtk_widget_get_preferred_size(topHandle, requisition);
                if (GTK.GTK4) {
                    GTK.gtk_widget_size_allocate(topHandle, allocation, -1);
                } else {
                    GTK.gtk_widget_size_allocate(topHandle, allocation);
                }
                GTK.gtk_widget_hide(topHandle);
                if (focusControl != null && this.display.getFocusControl() != focusControl) {
                    focusControl.setFocus();
                }
            } else if (GTK.GTK4) {
                GTK.gtk_widget_size_allocate(topHandle, allocation, -1);
            } else {
                GTK.gtk_widget_get_preferred_size(topHandle, null, null);
                GTK.gtk_widget_size_allocate(topHandle, allocation);
            }
        }
        if (!sameExtent) {
            this.state = width == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n = this.state = height == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if (GTK.GTK4) {
                if ((this.state & 0x600) != 0) {
                    if (this.enableSurface != 0L) {
                        GDK.gdk_surface_hide(this.enableSurface);
                    }
                    GTK.gtk_widget_hide(topHandle);
                } else if ((this.state & 0x800) == 0) {
                    if (this.enableSurface != 0L) {
                        // empty if block
                    }
                    GTK.gtk_widget_show(topHandle);
                }
            } else if ((this.state & 0x600) != 0) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_hide(this.enableWindow);
                }
                GTK.gtk_widget_hide(topHandle);
            } else if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                GTK.gtk_widget_show(topHandle);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(clientWidth);
            }
        }
        int result = 0;
        if (move && !sameOrigin) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (sendMove) {
                this.sendEvent(10);
            }
            result |= 0x80;
        }
        if (resize && !sameExtent) {
            this.sendEvent(11);
            result |= 0x100;
        }
        return result;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        if ((this.parent.style & 0x8000000) != 0) {
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            x = this.parent.getClientWidth() - width - x;
        }
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.autoScaleUp(location);
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        Point loc = DPIUtil.autoScaleUp(new Point(x, y));
        this.setBounds(loc.x, loc.y, 0, 0, true, false);
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        return new Point(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        size = DPIUtil.autoScaleUp(size);
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    void setSizeInPixels(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long shape_region = region == null ? 0L : region.handle;
        this.region = region;
        long topHandle = this.topHandle();
        if (OS.G_OBJECT_TYPE(topHandle) == GTK.GTK_TYPE_WINDOW()) {
            GTK.gtk_widget_shape_combine_region(topHandle, shape_region);
            if (!OS.isX11()) {
                double alpha = GTK.gtk_widget_get_opacity(topHandle);
                if (alpha == 1.0) {
                    alpha = 0.99;
                }
                GTK.gtk_widget_set_opacity(topHandle, alpha);
            }
        } else {
            boolean bl = this.drawRegion = this.region != null && this.region.handle != 0L;
            if (this.drawRegion) {
                this.cairoCopyRegion(this.region);
            } else {
                this.cairoDisposeRegion();
            }
            GTK.gtk_widget_queue_draw(this.topHandle());
        }
    }

    void setRelations() {
        Widget widget;
        long parentHandle = this.parent.parentingHandle();
        long handle = 0L;
        if (GTK.GTK4) {
            int count = 0;
            long child = GTK.gtk_widget_get_first_child(parentHandle);
            while (child != 0L) {
                ++count;
                child = GTK.gtk_widget_get_next_sibling(child);
            }
            if (count > 1) {
                handle = GTK.gtk_widget_get_prev_sibling(GTK.gtk_widget_get_last_child(parentHandle));
            }
        } else {
            long list = GTK.gtk_container_get_children(parentHandle);
            if (list == 0L) {
                return;
            }
            int count = OS.g_list_length(list);
            if (count > 1) {
                handle = OS.g_list_nth_data(list, count - 2);
            }
            OS.g_list_free(list);
        }
        if (handle != 0L && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
            Control sibling = (Control)widget;
            sibling.addRelation(this);
        }
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        Point size = DPIUtil.autoScaleUp(new Point(width, height));
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true);
    }

    void setSizeInPixels(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    @Override
    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    @Override
    public boolean isAutoScalable() {
        return this.autoScale;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(long widget) {
        return widget == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int oldWidth) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        if (GTK.GTK4) {
            long surface = this.eventSurface();
            GDK.gdk_surface_get_origin(surface, origin_x, origin_y);
        } else {
            long window = this.eventWindow();
            GDK.gdk_window_get_origin(window, origin_x, origin_y);
        }
        x -= DPIUtil.autoScaleDown(origin_x[0]);
        y -= DPIUtil.autoScaleDown(origin_y[0]);
        if ((this.style & 0x8000000) != 0) {
            x = DPIUtil.autoScaleDown(this.getClientWidth()) - x;
        }
        return new Point(x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        if (GTK.GTK4) {
            long surface = this.eventSurface();
            GDK.gdk_surface_get_origin(surface, origin_x, origin_y);
        } else {
            long window = this.eventWindow();
            GDK.gdk_window_get_origin(window, origin_x, origin_y);
        }
        if ((this.style & 0x8000000) != 0) {
            x = DPIUtil.autoScaleDown(this.getClientWidth()) - x;
        }
        return new Point(x += DPIUtil.autoScaleDown(origin_x[0]), y += DPIUtil.autoScaleDown(origin_y[0]));
    }

    Point toDisplayInPixels(int x, int y) {
        this.checkWidget();
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        if (GTK.GTK4) {
            long surface = this.eventSurface();
            GDK.gdk_surface_get_origin(surface, origin_x, origin_y);
        } else {
            long window = this.eventWindow();
            GDK.gdk_window_get_origin(window, origin_x, origin_y);
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        return new Point(x += origin_x[0], y += origin_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    Point toDisplayInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplayInPixels(point.x, point.y);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    void adjustChildClipping(long widget) {
    }

    void addRelation(Control control) {
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        if (this.labelRelation != null) {
            this._getAccessible().removeRelation(9, this.labelRelation._getAccessible());
            this.labelRelation = null;
        }
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, true, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y, true);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean dragging = false;
        if (!OS.isX11()) {
            double[] offsetX = new double[1];
            double[] offsetY = new double[1];
            double[] startX = new double[1];
            double[] startY = new double[1];
            if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
                GTK.gtk_gesture_drag_get_offset(this.dragGesture, offsetX, offsetY);
                if (GTK.gtk_drag_check_threshold(this.handle, (int)startX[0], (int)startY[0], (int)startX[0] + (int)offsetX[0], (int)startY[0] + (int)offsetY[0])) {
                    dragging = true;
                }
            } else {
                return false;
            }
            do {
                if (mouseDown) continue;
                return false;
            } while (!this.dragBegun);
            return true;
        }
        boolean quit = false;
        Point startPos = null;
        Point currPos = null;
        startPos = this.display.getCursorLocationInPixels();
        while (!quit) {
            long eventPtr = 0L;
            long timeout = System.currentTimeMillis() + 500L;
            this.display.sendPreExternalEventDispatchEvent();
            while (System.currentTimeMillis() < timeout) {
                long l = eventPtr = GTK.GTK4 ? GTK.gtk_get_current_event() : GDK.gdk_event_get();
                if (eventPtr != 0L) break;
                currPos = this.display.getCursorLocationInPixels();
                dragging = GTK.gtk_drag_check_threshold(this.handle, startPos.x, startPos.y, currPos.x, currPos.y);
                if (!dragging) continue;
            }
            this.display.sendPostExternalEventDispatchEvent();
            if (dragging) {
                return true;
            }
            if (eventPtr == 0L) {
                return dragOnTimeout;
            }
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Control.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 3: {
                    long gdkResource = this.gdk_event_get_surface_or_window(eventPtr);
                    int[] state = new int[1];
                    double[] eventX = new double[1];
                    double[] eventY = new double[1];
                    if (GTK.GTK4) {
                        state[0] = GDK.gdk_event_get_modifier_state(eventPtr);
                        GDK.gdk_event_get_position(eventPtr, eventX, eventY);
                    } else {
                        GDK.gdk_event_get_state(eventPtr, state);
                        GDK.gdk_event_get_coords(eventPtr, eventX, eventY);
                    }
                    if ((state[0] & 0x100) != 0) {
                        if (GTK.gtk_drag_check_threshold(this.handle, x, y, (int)eventX[0], (int)eventY[0])) {
                            dragging = true;
                            quit = true;
                        }
                    } else {
                        quit = true;
                    }
                    int[] newX = new int[1];
                    int[] newY = new int[1];
                    if (GTK.GTK4) {
                        double[] newXDouble = new double[1];
                        double[] newYDouble = new double[1];
                        this.display.getSurfacePointerPosition(gdkResource, newXDouble, newYDouble, null);
                        newX[0] = (int)newXDouble[0];
                        newY[0] = (int)newYDouble[0];
                        break;
                    }
                    this.display.getWindowPointerPosition(gdkResource, newX, newY, null);
                    break;
                }
                case 8: 
                case 9: {
                    int[] eventKeyval = new int[1];
                    if (GTK.GTK4) {
                        eventKeyval[0] = GDK.gdk_key_event_get_keyval(eventPtr);
                    } else {
                        GDK.gdk_event_get_keyval(eventPtr, eventKeyval);
                    }
                    if (eventKeyval[0] != 65307) break;
                    quit = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (GTK.GTK4) {
                        long display = GDK.gdk_display_get_default();
                        GDK.gdk_display_put_event(display, eventPtr);
                    } else {
                        GDK.gdk_event_put(eventPtr);
                    }
                    quit = true;
                    break;
                }
                default: {
                    GTK.gtk_main_do_event(eventPtr);
                }
            }
            this.gdk_event_free(eventPtr);
        }
        return dragging;
    }

    boolean filterKey(int keyval, long event) {
        long imHandle = this.imHandle();
        if (imHandle != 0L) {
            return GTK.gtk_im_context_filter_keypress(imHandle, event);
        }
        return false;
    }

    Control findBackgroundControl() {
        if (((this.state & 0x2000) != 0 || this.backgroundImage != null) && this.backgroundAlpha > 0) {
            return this;
        }
        return this.parent != null && (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    void fixParentGdkResource() {
        this.parent.setParentGdkResource(this);
    }

    static void gtk_widget_reparent(Control control, long newParentHandle) {
        long widget = control.topHandle();
        long parentContainer = GTK.gtk_widget_get_parent(widget);
        assert (parentContainer != 0L) : "Improper use of Control.gtk_widget_reparent. Widget currently has no parent.";
        if (parentContainer != 0L) {
            GTK.gtk_widget_reparent(widget, newParentHandle);
            control.fixParentGdkResource();
        }
    }

    void fixModal(long group, long modalGroup) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(long focusHandle) {
        if (GTK.gtk_widget_has_focus(focusHandle)) {
            return true;
        }
        GTK.gtk_widget_realize(focusHandle);
        GTK.gtk_widget_grab_focus(focusHandle);
        if (this.isDisposed()) {
            return false;
        }
        Shell shell = this.getShell();
        long shellHandle = shell.shellHandle;
        long handle = GTK.gtk_window_get_focus(shellHandle);
        while (handle != 0L) {
            if (handle == focusHandle) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(handle);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            handle = GTK.gtk_widget_get_parent(handle);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundAlpha == 0) {
            Color color = Color.gtk_new(this.display, this.getBackgroundGdkRGBA(), 0);
            return color;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new(this.display, control.getBackgroundGdkRGBA(), this.backgroundAlpha);
    }

    GdkRGBA getBackgroundGdkRGBA() {
        return this.getBgGdkRGBA();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkRGBA getContextBackgroundGdkRGBA() {
        if ((this.state & 0x2000) == 0) {
            return this.defaultBackground();
        }
        if (this.provider != 0L) {
            return this.display.gtk_css_parse_background(this.display.gtk_css_provider_to_string(this.provider), null);
        }
        return this.defaultBackground();
    }

    GdkRGBA getContextColorGdkRGBA() {
        return this.display.gtk_css_parse_foreground(this.display.gtk_css_provider_to_string(this.provider), null);
    }

    GdkRGBA getBgGdkRGBA() {
        return this.getContextBackgroundGdkRGBA();
    }

    GdkRGBA getBaseGdkRGBA() {
        return this.getContextBackgroundGdkRGBA();
    }

    public int getBorderWidth() {
        return DPIUtil.autoScaleDown(this.getBorderWidthInPixels());
    }

    int getBorderWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        if (this.handle == 0L || (this.state & 0x200) != 0) {
            return 0;
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        return allocation.width;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    long getFontDescription() {
        long fontHandle = this.fontHandle();
        long[] fontDesc = new long[1];
        long context = GTK.gtk_widget_get_style_context(fontHandle);
        if ("ppc64le".equals(System.getProperty("os.arch"))) {
            return GTK.gtk_style_context_get_font(context, 0);
        }
        if (GTK.GTK4) {
            GTK.gtk_style_context_get(context, GTK.gtk_style_property_font, fontDesc, 0L);
            return fontDesc[0];
        }
        GTK.gtk_style_context_save(context);
        GTK.gtk_style_context_set_state(context, 0L);
        GTK.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, fontDesc, 0L);
        GTK.gtk_style_context_restore(context);
        return fontDesc[0];
    }

    public Color getForeground() {
        this.checkWidget();
        Color color = Color.gtk_new(this.display, this.getForegroundGdkRGBA());
        return color;
    }

    GdkRGBA getForegroundGdkRGBA() {
        return this.getContextColorGdkRGBA();
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            long display = GDK.gdk_display_get_default();
            if (display != 0L) {
                long monitor = GTK.GTK4 ? GDK.gdk_display_get_monitor_at_surface(display, this.paintSurface()) : GDK.gdk_display_get_monitor_at_window(display, this.paintWindow());
                for (int i = 0; i < monitors.length; ++i) {
                    long toCompare = GDK.gdk_display_get_monitor(display, i);
                    if (toCompare != monitor) continue;
                    return monitors[i];
                }
            }
        } else {
            int monitorNumber;
            long screen = GDK.gdk_screen_get_default();
            if (screen != 0L && (monitorNumber = GDK.gdk_screen_get_monitor_at_window(screen, this.paintWindow())) >= 0 && monitorNumber < monitors.length) {
                return monitors[monitorNumber];
            }
        }
        return this.display.getPrimaryMonitor();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    Point getThickness(long widget) {
        int xthickness = 0;
        int ythickness = 0;
        GtkBorder tmp = new GtkBorder();
        long context = GTK.gtk_widget_get_style_context(widget);
        int state_flag = GTK.gtk_widget_get_state_flags(widget);
        this.gtk_style_context_get_padding(context, state_flag, tmp);
        GTK.gtk_style_context_save(context);
        GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_FRAME);
        xthickness += tmp.left;
        ythickness += tmp.top;
        int state = GTK.gtk_widget_get_state_flags(widget);
        this.gtk_style_context_get_border(context, state, tmp);
        GTK.gtk_style_context_restore(context);
        return new Point(xthickness += tmp.left, ythickness += tmp.top);
    }

    void gtk_style_context_get_padding(long context, int state, GtkBorder padding) {
        if (GTK.GTK4) {
            GTK.gtk_style_context_get_padding(context, padding);
        } else {
            GTK.gtk_style_context_get_padding(context, state, padding);
        }
    }

    void gtk_style_context_get_border(long context, int state, GtkBorder padding) {
        if (GTK.GTK4) {
            GTK.gtk_style_context_get_border(context, padding);
        } else {
            GTK.gtk_style_context_get_border(context, state, padding);
        }
    }

    @Override
    long gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        mouseDown = true;
        this.dragBegun = false;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        GDK.gdk_event_get_position(event, eventX, eventY);
        int eventButton = GDK.gdk_button_event_get_button(event);
        int eventTime = GDK.gdk_event_get_time(event);
        int eventState = GDK.gdk_event_get_modifier_state(event);
        boolean mouseEventSent = this.sendMouseEvent(3, eventButton, n_press, 0, false, eventTime, eventX[0], eventY[0], true, eventState);
        return mouseEventSent ? 1L : 0L;
    }

    @Override
    long gtk_gesture_release_event(long gesture, int n_press, double x, double y, long event) {
        mouseDown = false;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        GDK.gdk_event_get_position(event, eventX, eventY);
        int eventButton = GDK.gdk_button_event_get_button(event);
        int eventTime = GDK.gdk_event_get_time(event);
        int eventState = GDK.gdk_event_get_modifier_state(event);
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        return this.sendMouseEvent(4, eventButton, this.display.clickCount, 0, false, eventTime, 0.0, 0.0, false, eventState) ? 0L : 1L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        return this.gtk_button_press_event(widget, event, true);
    }

    long gtk_button_press_event(long widget, long event, boolean sendMouseDown) {
        mouseDown = true;
        this.dragBegun = false;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        GDK.gdk_event_get_coords(event, eventX, eventY);
        int eventType = GDK.gdk_event_get_event_type(event);
        int[] eventButton = new int[1];
        int[] eventState = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        GDK.gdk_event_get_state(event, eventState);
        int eventTime = GDK.gdk_event_get_time(event);
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (eventType == 6) {
            return 0L;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        long result = 0L;
        if (eventType == 4) {
            boolean dragging = false;
            this.display.clickCount = 1;
            long nextEvent = this.gdk_event_peek();
            if (nextEvent != 0L) {
                int peekedEventType = GDK.GDK_EVENT_TYPE(nextEvent);
                if (peekedEventType == 5) {
                    this.display.clickCount = 2;
                }
                if (peekedEventType == 6) {
                    this.display.clickCount = 3;
                }
                this.gdk_event_free(nextEvent);
            }
            if (OS.isX11() && (this.state & 0x800000) != 0 && this.hooks(29) && eventButton[0] == 1) {
                boolean[] consume = new boolean[1];
                if (this.dragDetect((int)eventX[0], (int)eventY[0], true, true, consume)) {
                    dragging = true;
                    if (consume[0]) {
                        result = 1L;
                    }
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (sendMouseDown) {
                boolean mouseEventSent;
                boolean bl = mouseEventSent = !this.sendMouseEvent(3, eventButton[0], this.display.clickCount, 0, false, eventTime, eventRX[0], eventRY[0], false, eventState[0]);
                if (mouseEventSent) {
                    result = 1L;
                }
            }
            if (this.isDisposed()) {
                return 1L;
            }
            if (OS.isX11() && dragging) {
                Point scaledEvent = DPIUtil.autoScaleDown(new Point((int)eventX[0], (int)eventY[0]));
                this.sendDragEvent(eventButton[0], eventState[0], scaledEvent.x, scaledEvent.y, false);
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if ((this.state & 0x20) != 0 && eventButton[0] == 3 && this.showMenu((int)eventRX[0], (int)eventRY[0])) {
                result = 1L;
            }
        } else {
            this.display.clickCount = 2;
            long l = result = this.sendMouseEvent(8, eventButton[0], this.display.clickCount, 0, false, eventTime, eventRX[0], eventRY[0], false, eventState[0]) ? 0L : 1L;
            if (this.isDisposed()) {
                return 1L;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this, 3);
        }
        return result;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        mouseDown = false;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        GDK.gdk_event_get_coords(event, eventX, eventY);
        int[] eventButton = new int[1];
        int[] eventState = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        GDK.gdk_event_get_state(event, eventState);
        int eventTime = GDK.gdk_event_get_time(event);
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        return this.sendMouseEvent(4, eventButton[0], this.display.clickCount, 0, false, eventTime, eventRX[0], eventRY[0], false, eventState[0]) ? 0L : 1L;
    }

    @Override
    long gtk_commit(long imcontext, long text) {
        if (text == 0L) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        this.sendIMKeyEvent(1, 0L, chars);
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long widget, long event) {
        if (GTK.GTK4) {
            if (this.display.currentControl == this) {
                return 0L;
            }
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                this.display.currentControl.sendMouseEvent(7, 0, 0, 0.0, 0.0, false, 0);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                return this.sendMouseEvent(6, 0, 0, 0.0, 0.0, false, 0) ? 0L : 1L;
            }
            return 0L;
        }
        byte[] buffer = null;
        if (this.toolTipText != null && this.toolTipText.length() != 0) {
            char[] chars = this.fixMnemonic(this.toolTipText, false, true);
            buffer = Converter.wcsToMbcs(chars, true);
        }
        long toolHandle = this.getShell().handle;
        GTK.gtk_widget_set_tooltip_text(toolHandle, buffer);
        if (this.display.currentControl == this) {
            return 0L;
        }
        int[] state = new int[1];
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            state[0] = GDK.gdk_event_get_modifier_state(event);
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_state(event, state);
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        int time = GDK.gdk_event_get_time(event);
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        long childGdkResource = 0L;
        int[] crossingMode = new int[1];
        if (GTK.GTK4) {
            crossingMode[0] = GDK.gdk_crossing_event_get_mode(event);
        } else {
            OS.memmove(gdkEvent, event, (long)GdkEventCrossing.sizeof);
            crossingMode[0] = gdkEvent.mode;
            childGdkResource = gdkEvent.subwindow;
        }
        if (childGdkResource != 0L && this.checkSubwindow()) {
            return 0L;
        }
        if (crossingMode[0] != 0 && crossingMode[0] != 2) {
            return 0L;
        }
        if ((state[0] & 0x700) != 0) {
            return 0L;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, time, eventRX[0], eventRY[0], false, state[0]);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, time, eventRX[0], eventRY[0], false, state[0]) ? 0L : 1L;
        }
        return 0L;
    }

    boolean checkSubwindow() {
        return false;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: {
                if (widget != this.eventHandle() || (this.state & 0x20) != 0) break;
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(gdkEvent, eventRX, eventRY);
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                if (eventButton[0] != 3) break;
                this.showMenu((int)eventRX[0], (int)eventRY[0]);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(widget)) break;
                boolean[] focusIn = new boolean[1];
                if (GTK.GTK4) {
                    focusIn[0] = GDK.gdk_focus_event_get_in(gdkEvent);
                } else {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                    focusIn[0] = gdkEventFocus.in != 0;
                }
                Display display = this.display;
                if (focusIn[0]) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    long grabHandle = GTK.gtk_grab_get_current();
                    if (grabHandle != 0L && OS.G_OBJECT_TYPE(grabHandle) == GTK.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(focusIn[0] ? 15 : 16);
                break;
            }
        }
        return 0L;
    }

    void cairoCopyRegion(Region region) {
        if (region == null || region.isDisposed() || region.handle == 0L) {
            return;
        }
        this.regionHandle = Cairo.cairo_region_copy(region.handle);
    }

    void cairoDisposeRegion() {
        if (this.regionHandle != 0L) {
            Cairo.cairo_region_destroy(this.regionHandle);
        }
        if (this.eventRegion != 0L) {
            Cairo.cairo_region_destroy(this.eventRegion);
        }
        this.regionHandle = 0L;
        this.eventRegion = 0L;
    }

    void cairoClipRegion(long cairo) {
        GdkRectangle rect = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
        long regionHandle = this.regionHandle;
        if (regionHandle == 0L) {
            this.drawRegion = false;
            return;
        }
        cairo_rectangle_int_t cairoRect = new cairo_rectangle_int_t();
        cairoRect.convertFromGdkRectangle(rect);
        long actualRegion = Cairo.cairo_region_create_rectangle(cairoRect);
        Cairo.cairo_region_subtract(actualRegion, regionHandle);
        Shell shell = this.getShell();
        Color shellBg = shell.getBackground();
        if (shellBg != this.getBackground()) {
            GdkRGBA rgba = shellBg.handle;
            Cairo.cairo_set_source_rgba(cairo, rgba.red, rgba.green, rgba.blue, rgba.alpha);
        } else {
            Cairo.cairo_set_source_rgba(cairo, 0.0, 0.0, 0.0, 0.0);
        }
        GDK.gdk_cairo_region(cairo, actualRegion);
        Cairo.cairo_clip(cairo);
        Cairo.cairo_paint(cairo);
        this.eventRegion = actualRegion;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        long surface;
        if (GTK.GTK4) {
            if (!this.hooksPaint()) {
                return 0L;
            }
            GCData data = new GCData();
            data.cairo = cairo;
            GC gc = GC.gtk_new(this, data);
            Event event = new Event();
            event.count = 1;
            event.gc = gc;
            this.drawWidget(gc);
            this.sendEvent(9, event);
            gc.dispose();
            event.gc = null;
            return 0L;
        }
        if (this.checkScaleFactor && (surface = Cairo.cairo_get_target(cairo)) != 0L) {
            double[] sx = new double[1];
            double[] sy = new double[1];
            Cairo.cairo_surface_get_device_scale(surface, sx, sy);
            long display = GDK.gdk_display_get_default();
            long monitor = GDK.gdk_display_get_monitor_at_point(display, 0, 0);
            int scale = GDK.gdk_monitor_get_scale_factor(monitor);
            this.autoScale = (long)scale != Math.round(sx[0]);
            this.checkScaleFactor = false;
        }
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        GdkRectangle rect = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
        if (this.drawRegion) {
            this.cairoClipRegion(cairo);
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        Event event = new Event();
        event.count = 1;
        Rectangle eventBounds = DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height));
        if ((this.style & 0x8000000) != 0) {
            eventBounds.x = DPIUtil.autoScaleDown(this.getClientWidth()) - eventBounds.width - eventBounds.x;
        }
        event.setBounds(eventBounds);
        GCData data = new GCData();
        if (this.drawRegion) {
            data.regionSet = this.eventRegion;
        }
        data.cairo = cairo;
        GC gc = event.gc = GC.gtk_new(this, data);
        gc.setClipping(eventBounds.x, eventBounds.y, eventBounds.width, eventBounds.height);
        this.drawWidget(gc);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        return 1L;
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        if (this.handle != 0L) {
            long imHandle;
            long oldIMHandle;
            Control oldControl = this.display.imControl;
            if (oldControl != this && oldControl != null && !oldControl.isDisposed() && (oldIMHandle = oldControl.imHandle()) != 0L) {
                GTK.gtk_im_context_reset(oldIMHandle);
            }
            if ((this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0L) {
                GTK.gtk_im_context_focus_in(imHandle);
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long imHandle;
        if (this.handle != 0L && (this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0L) {
            GTK.gtk_im_context_focus_out(imHandle);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        int[] eventKeyval = new int[1];
        if (GTK.GTK4) {
            eventKeyval[0] = GDK.gdk_key_event_get_keyval(event);
        } else {
            GDK.gdk_event_get_keyval(event, eventKeyval);
        }
        if (!this.hasFocus()) {
            if (this.display.getActiveShell() == null && this.filterKey(eventKeyval[0], event)) {
                return 1L;
            }
            return 0L;
        }
        if (this.translateMnemonic(eventKeyval[0], event)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.filterKey(eventKeyval[0], event)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.translateTraversal(event)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        return super.gtk_key_press_event(widget, event);
    }

    @Override
    long gtk_key_release_event(long widget, long event) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long imHandle = this.imHandle();
        if (imHandle != 0L && GTK.gtk_im_context_filter_keypress(imHandle, event)) {
            return 1L;
        }
        return super.gtk_key_release_event(widget, event);
    }

    @Override
    long gtk_leave_notify_event(long widget, long event) {
        if (GTK.GTK4) {
            if (this.display.currentControl != this) {
                return 0L;
            }
            this.display.removeMouseHoverTimeout(this.handle);
            int result = 0;
            if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
                result = this.sendMouseEvent(7, 0, 0, 0.0, 0.0, false, 0) ? 0 : 1;
                this.display.currentControl = null;
            }
            return result;
        }
        if (this.display.currentControl != this) {
            return 0L;
        }
        int[] state = new int[1];
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            state[0] = GDK.gdk_event_get_modifier_state(event);
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_state(event, state);
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        int time = GDK.gdk_event_get_time(event);
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        int[] crossingMode = new int[1];
        if (GTK.GTK4) {
            crossingMode[0] = GDK.gdk_crossing_event_get_mode(event);
        } else {
            OS.memmove(gdkEvent, event, (long)GdkEventCrossing.sizeof);
            crossingMode[0] = gdkEvent.mode;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int result = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            if (crossingMode[0] != 0 && crossingMode[0] != 2) {
                return 0L;
            }
            if ((state[0] & 0x700) != 0) {
                return 0L;
            }
            result = this.sendMouseEvent(7, 0, time, eventRX[0], eventRY[0], false, state[0]) ? 0 : 1;
            this.display.currentControl = null;
        }
        return result;
    }

    @Override
    long gtk_mnemonic_activate(long widget, long arg1) {
        int result = 0;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int type = GDK.gdk_event_get_event_type(eventPtr);
            if ((type = Control.fixGdkEventTypeValues(type)) == 8) {
                long focusHandle;
                Control focusControl = this.display.getFocusControl();
                long l = focusHandle = focusControl != null ? focusControl.focusHandle() : 0L;
                if (focusHandle != 0L) {
                    this.display.mnemonicControl = this;
                    GTK.gtk_widget_event(focusHandle, eventPtr);
                    this.display.mnemonicControl = null;
                }
                result = 1;
            }
            this.gdk_event_free(eventPtr);
        }
        return result;
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        double y;
        double x;
        if (mouseDown) {
            this.dragBegun = true;
        }
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (!OS.isX11()) {
            boolean[] consume;
            boolean dragging = false;
            if ((this.state & 0x800000) != 0 && this.hooks(29) && this.dragDetect((int)eventX[0], (int)eventY[0], true, true, consume = new boolean[1])) {
                dragging = true;
                if (consume[0]) {
                    boolean bl = true;
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (dragging) {
                GTK.gtk_event_controller_handle_event(this.dragGesture, event);
                int eventType = GDK.gdk_event_get_event_type(event);
                if (eventType == 6) {
                    return 0L;
                }
                Point scaledEvent = DPIUtil.autoScaleDown(new Point((int)eventX[0], (int)eventY[0]));
                int[] eventButton = new int[1];
                int[] eventState = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(event);
                    eventState[0] = GDK.gdk_event_get_modifier_state(event);
                } else {
                    GDK.gdk_event_get_button(event, eventButton);
                    GDK.gdk_event_get_state(event, eventState);
                }
                if (this.sendDragEvent(eventButton[0], eventState[0], scaledEvent.x, scaledEvent.y, false)) {
                    return 1L;
                }
            }
        }
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        int time = GDK.gdk_event_get_time(event);
        int[] state = new int[1];
        boolean isHint = false;
        if (GTK.GTK4) {
            state[0] = GDK.gdk_event_get_modifier_state(event);
            x = eventX[0];
            y = eventY[0];
        } else {
            double[] eventRX = new double[1];
            double[] eventRY = new double[1];
            GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
            x = eventRX[0];
            y = eventRY[0];
            GdkEventMotion gdkEvent = new GdkEventMotion();
            OS.memmove(gdkEvent, event, (long)GdkEventMotion.sizeof);
            state[0] = gdkEvent.state;
            boolean bl = isHint = gdkEvent.is_hint != 0;
            if (isHint) {
                int[] pointer_x = new int[1];
                int[] pointer_y = new int[1];
                int[] mask = new int[1];
                long window = this.eventWindow();
                this.display.getWindowPointerPosition(window, pointer_x, pointer_y, mask);
                x = pointer_x[0];
                y = pointer_y[0];
                state[0] = mask[0];
            }
        }
        if (this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                Point pt = this.display.mapInPixels(this, this.display.currentControl, (int)x, (int)y);
                this.display.currentControl.sendMouseEvent(7, 0, time, pt.x, pt.y, isHint, state[0]);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, time, x, y, isHint, state[0]);
            }
        }
        int result = this.sendMouseEvent(5, 0, time, x, y, isHint, state[0]) ? 0 : 1;
        return result;
    }

    @Override
    long gtk_popup_menu(long widget) {
        if (!this.hasFocus()) {
            return 0L;
        }
        int[] x = new int[1];
        int[] y = new int[1];
        if (!GTK.GTK4) {
            this.display.getWindowPointerPosition(0L, x, y, null);
        }
        return this.showMenu(x[0], y[0], 1) ? 1L : 0L;
    }

    @Override
    long gtk_preedit_changed(long imcontext) {
        this.display.showIMWindow(this);
        return 0L;
    }

    @Override
    long gtk_realize(long widget) {
        long imHandle;
        if (!GTK.GTK4 && (imHandle = this.imHandle()) != 0L) {
            long window = this.gtk_widget_get_window(this.paintHandle());
            GTK.gtk_im_context_set_client_window(imHandle, window);
        }
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_scroll_event(long widget, long eventPtr) {
        boolean fetched;
        long result = 0L;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        int[] state = new int[1];
        if (GTK.GTK4) {
            state[0] = GDK.gdk_event_get_modifier_state(eventPtr);
        } else {
            GDK.gdk_event_get_coords(eventPtr, eventX, eventY);
            GDK.gdk_event_get_state(eventPtr, state);
        }
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        if (GTK.GTK4) {
            long root = GTK.gtk_widget_get_root(widget);
            GTK.gtk_widget_translate_coordinates(widget, root, eventX[0], eventY[0], eventRX, eventRY);
        } else {
            GDK.gdk_event_get_root_coords(eventPtr, eventRX, eventRY);
        }
        int time = GDK.gdk_event_get_time(eventPtr);
        int[] direction = new int[1];
        if (GTK.GTK4) {
            direction[0] = GDK.gdk_scroll_event_get_direction(eventPtr);
            fetched = direction[0] != 4;
        } else {
            fetched = GDK.gdk_event_get_scroll_direction(eventPtr, direction);
        }
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (fetched) {
            switch (direction[0]) {
                case 0: {
                    return this.sendMouseEvent(37, 0, 3, 1, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0L : 1L;
                }
                case 1: {
                    return this.sendMouseEvent(37, 0, -3, 1, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0L : 1L;
                }
                case 2: {
                    return this.sendMouseEvent(38, 0, 3, 0, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0L : 1L;
                }
                case 3: {
                    return this.sendMouseEvent(38, 0, -3, 0, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0L : 1L;
                }
            }
        } else {
            boolean deltasAvailable;
            double[] delta_x = new double[1];
            double[] delta_y = new double[1];
            if (GTK.GTK4) {
                GDK.gdk_scroll_event_get_deltas(eventPtr, delta_x, delta_y);
                deltasAvailable = true;
            } else {
                deltasAvailable = GDK.gdk_event_get_scroll_deltas(eventPtr, delta_x, delta_y);
            }
            if (deltasAvailable) {
                if (delta_x[0] != 0.0) {
                    result = this.sendMouseEvent(38, 0, (int)(-3.0 * delta_x[0]), 0, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0 : 1;
                }
                if (delta_y[0] != 0.0) {
                    result = this.sendMouseEvent(37, 0, (int)(-3.0 * delta_y[0]), 1, true, time, eventRX[0], eventRY[0], false, state[0]) ? 0 : 1;
                }
            }
        }
        return result;
    }

    @Override
    long gtk_show_help(long widget, long helpType) {
        if (!this.hasFocus()) {
            return 0L;
        }
        return this.sendHelpEvent(helpType) ? 1L : 0L;
    }

    @Override
    long gtk_style_updated(long widget) {
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_unrealize(long widget) {
        long imHandle;
        if (!GTK.GTK4 && (imHandle = this.imHandle()) != 0L) {
            GTK.gtk_im_context_set_client_window(imHandle, 0L);
        }
        return 0L;
    }

    @Override
    public long internal_new_GC(GCData data) {
        long gc;
        long gdkResource;
        this.checkWidget();
        long l = gdkResource = GTK.GTK4 ? this.paintSurface() : this.paintWindow();
        if (gdkResource == 0L) {
            this.error(2);
        }
        if ((gc = data.cairo) != 0L) {
            Cairo.cairo_reference(gc);
        } else if (GTK.GTK4) {
            long surface = GDK.gdk_surface_create_similar_surface(gdkResource, 12288, data.width, data.height);
            gc = Cairo.cairo_create(surface);
        } else {
            gc = GDK.gdk_cairo_create(gdkResource);
        }
        if (gc == 0L) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.drawable = gdkResource;
            data.device = this.display;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            data.font = this.font != null ? this.font : this.defaultFont();
            data.foregroundRGBA = this.getForegroundGdkRGBA();
            data.backgroundRGBA = control.getBackgroundGdkRGBA();
        }
        return gc;
    }

    long imHandle() {
        return 0L;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        this.checkWidget();
        Cairo.cairo_destroy(hDC);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSizeInPixels();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                if (tabList[i] != this) continue;
                return true;
            }
        }
        if (((code = this.traversalCode(0, 0L)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                if (tabList[i] != this) continue;
                return false;
            }
        }
        return ((code = this.traversalCode(0, 0L)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    @Override
    void register() {
        long imHandle;
        super.register();
        if (this.fixedHandle != 0L) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((imHandle = this.imHandle()) != 0L) {
            this.display.addWidget(imHandle, this);
        }
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean all) {
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, all, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, all);
    }

    void redrawInPixels(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - width - x;
        }
        this.redrawWidget(x, y, width, height, false, all, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        if (GTK.GTK4) {
            long surface = this.paintSurface();
            if (redrawAll) {
                int[] w = new int[1];
                int[] h = new int[1];
                this.gdk_surface_get_size(surface, w, h);
                rect.width = w[0];
                rect.height = h[0];
            } else {
                rect.x = x;
                rect.y = y;
                rect.width = Math.max(0, width);
                rect.height = Math.max(0, height);
            }
        } else {
            long window = this.paintWindow();
            if (redrawAll) {
                int[] w = new int[1];
                int[] h = new int[1];
                this.gdk_window_get_size(window, w, h);
                rect.width = w[0];
                rect.height = h[0];
            } else {
                rect.x = x;
                rect.y = y;
                rect.width = Math.max(0, width);
                rect.height = Math.max(0, height);
            }
            GDK.gdk_window_invalidate_rect(window, rect, all);
        }
    }

    @Override
    void release(boolean destroy) {
        Control next = null;
        Control previous = null;
        if (destroy && this.parent != null) {
            int index;
            Control[] children = this.parent._getChildren();
            for (index = 0; index < children.length && children[index] != this; ++index) {
            }
            if (index > 0) {
                previous = children[index - 1];
            }
            if (index + 1 < children.length) {
                next = children[index + 1];
                next.removeRelation();
            }
            this.removeRelation();
        }
        super.release(destroy);
        if (destroy && previous != null && next != null) {
            previous.addRelation(next);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0L;
        this.parent = null;
        this.cairoDisposeRegion();
    }

    @Override
    void releaseParent() {
        this.parent.removeControl(this);
    }

    @Override
    void releaseWidget() {
        boolean hadFocus = this.display.getFocusControl() == this;
        super.releaseWidget();
        if (hadFocus) {
            this.fixFocus(this);
        }
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        if (GTK.GTK4) {
            if (this.enableSurface != 0L) {
                GDK.gdk_surface_destroy(this.enableSurface);
                this.enableSurface = 0L;
            }
            this.redrawSurface = 0L;
        } else {
            long imHandle = this.imHandle();
            if (imHandle != 0L && GTK.GTK_IS_IM_CONTEXT(imHandle)) {
                GTK.gtk_im_context_reset(imHandle);
                GTK.gtk_im_context_set_client_window(imHandle, 0L);
            }
            if (this.enableWindow != 0L) {
                GDK.gdk_window_set_user_data(this.enableWindow, 0L);
                GDK.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0L;
            }
            this.redrawWindow = 0L;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    void restackWindow(long window, long sibling, boolean above) {
        GDK.gdk_window_restack(window, sibling, above);
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y, boolean isStateMask) {
        Event event = new Event();
        event.button = button;
        Rectangle eventRect = new Rectangle(x, y, 0, 0);
        event.setBounds(eventRect);
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        if (isStateMask) {
            event.stateMask = stateMask;
        } else {
            this.setInputState(event, stateMask);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int type) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = type;
        this.sendEvent(type);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double delta) {
        if (this.containedInRegion(x, y)) {
            return false;
        }
        switch (detail) {
            case 8: {
                return this.sendGestureEvent(stateMask, detail, x, y, delta, 0, 0, 0.0);
            }
            case 32: {
                return this.sendGestureEvent(stateMask, detail, x, y, 0.0, 0, 0, delta);
            }
            case 2: {
                return this.sendGestureEvent(stateMask, detail, x, y, 0.0, 0, 0, delta);
            }
            case 4: {
                return this.sendGestureEvent(stateMask, detail, 0, 0, 0.0, 0, 0, 0.0);
            }
        }
        return false;
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double xDirection, double yDirection) {
        if (this.containedInRegion(x, y)) {
            return false;
        }
        if (detail == 16) {
            return this.sendGestureEvent(stateMask, detail, x, y, 0.0, (int)xDirection, (int)yDirection, 0.0);
        }
        return false;
    }

    boolean sendGestureEvent(int stateMask, int detail, int x, int y, double rotation, int xDirection, int yDirection, double magnification) {
        if (this.containedInRegion(x, y)) {
            return false;
        }
        Event event = new Event();
        event.stateMask = stateMask;
        event.detail = detail;
        event.x = x;
        event.y = y;
        switch (detail) {
            case 8: {
                event.rotation = rotation;
                break;
            }
            case 32: {
                event.magnification = magnification;
                break;
            }
            case 16: {
                event.xDirection = xDirection;
                event.yDirection = yDirection;
                break;
            }
        }
        this.postEvent(48, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendHelpEvent(long helpType) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int type, int button, int time, double x, double y, boolean is_hint, int state) {
        if (this.containedInRegion((int)x, (int)y)) {
            return true;
        }
        return this.sendMouseEvent(type, button, 0, 0, false, time, x, y, is_hint, state);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, int time, double x, double y, boolean is_hint, int state) {
        if (this.containedInRegion((int)x, (int)y)) {
            return true;
        }
        if (!this.hooks(type) && !this.filters(type)) {
            if (!OS.isX11() && this.dragDetectionQueue != null && type == 4 && this.dragDetectionQueue.size() == 1) {
                Event mouseDownEvent = this.dragDetectionQueue.getFirst();
                this.dragDetectionQueue = null;
                this.sendOrPost(3, mouseDownEvent);
            }
            return true;
        }
        Event event = new Event();
        event.time = time;
        event.button = button;
        event.detail = detail;
        event.count = count;
        if (is_hint) {
            Rectangle eventRect = new Rectangle((int)x, (int)y, 0, 0);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
        } else {
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            if (!GTK.GTK4) {
                long window = this.eventWindow();
                GDK.gdk_window_get_origin(window, origin_x, origin_y);
                Rectangle eventRect = new Rectangle((int)x - origin_x[0], (int)y - origin_y[0], 0, 0);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
            }
        }
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        this.setInputState(event, state);
        event.data = send;
        if (!OS.isX11()) {
            if (type == 3) {
                this.dragDetectionQueue = new LinkedList();
                this.dragDetectionQueue.add(event);
                return true;
            }
            if (this.dragDetectionQueue != null) {
                switch (type) {
                    case 5: {
                        if (this.dragDetect(event.x, event.y, false, true, null)) {
                            Event mouseDownEvent = this.dragDetectionQueue.getFirst();
                            mouseDownEvent.data = true;
                            this.dragDetectionQueue = null;
                            this.sendOrPost(3, mouseDownEvent);
                            break;
                        }
                        this.dragDetectionQueue.add(event);
                        break;
                    }
                    case 4: {
                        mouseDown = false;
                        boolean sendOrPostAll = send ? true : (Boolean)this.dragDetectionQueue.getFirst().data;
                        this.dragDetectionQueue.forEach(queuedEvent -> {
                            queuedEvent.data = sendOrPostAll;
                        });
                        this.sendOrPost(3, this.dragDetectionQueue.removeFirst());
                        this.dragDetectionQueue.forEach(queuedEvent -> this.sendOrPost(5, (Event)queuedEvent));
                        this.dragDetectionQueue = null;
                    }
                }
            }
        }
        return this.sendOrPost(type, event);
    }

    private boolean sendOrPost(int type, Event event) {
        assert (event.data != null) : "event.data should have been a Boolean, but received null";
        boolean send = (Boolean)event.data;
        event.data = null;
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    void gtk_widget_set_align(long widget, int hAlign, int vAlign) {
        GTK.gtk_widget_set_halign(widget, hAlign);
        GTK.gtk_widget_set_valign(widget, vAlign);
    }

    void gtk_label_set_align(long label, float xAlign, float yAlign) {
        GTK.gtk_label_set_xalign(label, xAlign);
        GTK.gtk_label_set_yalign(label, yAlign);
    }

    void setBackground() {
        if ((this.state & 0x2000) == 0 && this.backgroundImage == null) {
            if ((this.state & 0x8000) != 0) {
                this.setParentBackground();
            } else {
                this.setWidgetBackground();
            }
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this._setBackground(color);
        if (color != null) {
            this.updateBackgroundMode();
        }
    }

    private void _setBackground(Color color) {
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        boolean set = false;
        GdkRGBA rgba = null;
        if (color != null) {
            rgba = color.handle;
            this.backgroundAlpha = color.getAlpha();
        }
        if (set = true) {
            this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
            this.setBackgroundGdkRGBA(rgba);
        }
        this.redrawChildren();
    }

    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String css;
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handle;
        String name = this.display.gtk_widget_class_get_css_name(handle);
        this.cssBackground = css = name + " {background-color: " + this.display.gtk_rgba_to_css_string(rgba) + ";}\n" + name + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    void gtk_css_provider_load_from_css(long context, String css) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L);
        } else {
            GTK.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L, null);
        }
    }

    void setBackgroundGdkRGBA(GdkRGBA rgba) {
        this.setBackgroundGdkRGBA(this.handle, rgba);
    }

    void setBackgroundGdkRGBA(long handle, GdkRGBA rgba) {
        double alpha = 1.0;
        if (rgba == null) {
            if ((this.state & 0x8000) != 0) {
                alpha = 0.0;
                Control control = this.findBackgroundControl();
                if (control == null) {
                    control = this;
                }
                rgba = control.getBackgroundGdkRGBA();
            }
        } else {
            alpha = this.backgroundAlpha;
        }
        if (rgba != null) {
            rgba.alpha = alpha / 255.0;
        }
        long context = GTK.gtk_widget_get_style_context(handle);
        this.setBackgroundGdkRGBA(context, handle, rgba);
        GTK.gtk_style_context_invalidate(context);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage && this.backgroundAlpha > 0) {
            return;
        }
        this.backgroundAlpha = 255;
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundSurface(Image image) {
        long window = GTK.gtk_widget_get_window(this.paintHandle());
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            return;
        }
        if (window != 0L && image.surface != 0L) {
            long pattern = Cairo.cairo_pattern_create_for_surface(image.surface);
            if (pattern == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_pattern_set_extend(pattern, 1);
            GDK.gdk_window_set_background_pattern(window, pattern);
            Cairo.cairo_pattern_destroy(pattern);
        }
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0L);
    }

    void setCursor(long cursor) {
        if (GTK.GTK4) {
            long eventHandle = this.eventHandle();
            GTK.gtk_widget_set_cursor(eventHandle, cursor);
        } else {
            long window = this.eventWindow();
            if (window != 0L) {
                GDK.gdk_window_set_cursor(window, cursor);
                this.update(false, true);
            }
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (GTK.GTK4) {
            if (enabled) {
                if (this.enableSurface != 0L) {
                    this.cleanupEnableSurface();
                }
            } else {
                GTK.gtk_widget_realize(this.handle);
                long parentHandle = this.parent.eventHandle();
                this.enableSurface = GDK.gdk_surface_new_popup(parentHandle, false);
                if (this.enableSurface != 0L) {
                    long topHandle = this.topHandle();
                    GtkAllocation allocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(topHandle, allocation);
                    GdkRectangle anchor = new GdkRectangle();
                    anchor.x = allocation.x;
                    anchor.y = allocation.y;
                    anchor.width = (this.state & 0x200) != 0 ? 0 : allocation.width;
                    anchor.height = (this.state & 0x400) != 0 ? 0 : allocation.height;
                    long layout = GDK.gdk_popup_layout_new(anchor, 1, 1);
                    GDK.gdk_popup_present(this.enableSurface, anchor.width, anchor.height, layout);
                }
            }
        } else if (enabled) {
            if (this.enableWindow != 0L) {
                this.cleanupEnableWindow();
            }
        } else {
            GTK.gtk_widget_realize(this.handle);
            long parentHandle = this.parent.eventHandle();
            long window = this.parent.eventWindow();
            long topHandle = this.topHandle();
            GdkWindowAttr attributes = new GdkWindowAttr();
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(topHandle, allocation);
            attributes.x = allocation.x;
            attributes.y = allocation.y;
            attributes.width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            attributes.height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = GDK.gdk_window_new(window, attributes, 12);
            if (this.enableWindow != 0L) {
                GDK.gdk_window_set_user_data(this.enableWindow, parentHandle);
                this.restackWindow(this.enableWindow, this.gtk_widget_get_window(topHandle), true);
                if (GTK.gtk_widget_get_visible(topHandle)) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void cleanupEnableWindow() {
        GDK.gdk_window_set_user_data(this.enableWindow, 0L);
        GDK.gdk_window_destroy(this.enableWindow);
        this.enableWindow = 0L;
    }

    void cleanupEnableSurface() {
        GDK.gdk_surface_destroy(this.enableSurface);
        this.enableSurface = 0L;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        long fontDesc;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            fontDesc = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                this.error(5);
            }
            fontDesc = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(fontDesc);
    }

    void setFontDescription(long font) {
        this.setFontDescription(this.handle, font);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        boolean set = false;
        boolean bl = set = !this.getForeground().equals(color);
        if (set) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            GdkRGBA rgba = color == null ? null : color.handle;
            this.setForegroundGdkRGBA(rgba);
        }
    }

    void setForegroundGdkRGBA(GdkRGBA rgba) {
        this.setForegroundGdkRGBA(this.handle, rgba);
    }

    void setForegroundGdkRGBA(long handle, GdkRGBA rgba) {
        String css;
        GdkRGBA toSet = rgba != null ? rgba : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long context = GTK.gtk_widget_get_style_context(handle);
        String color = this.display.gtk_rgba_to_css_string(toSet);
        String name = this.display.gtk_widget_class_get_css_name(handle);
        GdkRGBA selectedForeground = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
        String selection = !name.contains("treeview") ? " selection" : ":selected";
        this.cssForeground = css = "* {color: " + color + ";}\n" + name + selection + " {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            long topHandle = this.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            allocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
            allocation.y = 0;
            if (this.mustBeVisibleOnInitBounds()) {
                GTK.gtk_widget_set_visible(topHandle, true);
            }
            if (GTK.GTK4) {
                GTK.gtk_widget_size_allocate(topHandle, allocation, -1);
            } else {
                GTK.gtk_widget_get_preferred_size(topHandle, null, null);
                GTK.gtk_widget_size_allocate(topHandle, allocation);
            }
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    boolean mustBeVisibleOnInitBounds() {
        return false;
    }

    private void setDragGesture() {
        this.dragGesture = GTK.gtk_gesture_drag_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.dragGesture, 2);
        GTK.gtk_gesture_single_set_button(this.dragGesture, 0);
        OS.g_signal_connect(this.dragGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.dragGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    private void setRotateGesture() {
        this.rotateGesture = GTK.gtk_gesture_rotate_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.rotateGesture, 2);
        OS.g_signal_connect(this.rotateGesture, OS.angle_changed, gestureRotation.getAddress(), this.handle);
        OS.g_signal_connect(this.rotateGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.rotateGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    private void setZoomGesture() {
        this.zoomGesture = GTK.gtk_gesture_zoom_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.zoomGesture, 2);
        OS.g_signal_connect(this.zoomGesture, OS.scale_changed, gestureZoom.getAddress(), this.handle);
        OS.g_signal_connect(this.zoomGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.zoomGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    static Control getControl(long handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (Control)widget;
    }

    static void rotateProc(long gesture, double angle, double angle_delta, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            double delta = -(GTK.gtk_gesture_rotate_get_angle_delta(gesture) * 100.0);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 8, (int)x[0], (int)y[0], delta);
        }
    }

    static void magnifyProc(long gesture, double zoom, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            double delta = GTK.gtk_gesture_zoom_get_scale_delta(gesture);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 32, (int)x[0], (int)y[0], delta);
        }
    }

    static void swipeProc(long gesture, double velocity_x, double velocity_y, long user_data) {
        double[] yVelocity;
        double[] xVelocity;
        if (GTK.gtk_gesture_is_recognized(gesture) && GTK.gtk_gesture_swipe_get_velocity(gesture, xVelocity = new double[1], yVelocity = new double[1])) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 16, (int)x[0], (int)y[0], xVelocity[0], yVelocity[0]);
        }
    }

    static void gestureBeginProc(long gesture, long sequence, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, sequence, x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 2, (int)x[0], (int)y[0], 0.0);
        }
    }

    static void gestureEndProc(long gesture, long sequence, long user_data) {
        if (GTK.gtk_gesture_is_recognized(gesture)) {
            int[] state = new int[1];
            double[] x = new double[1];
            double[] y = new double[1];
            GTK.gtk_get_current_event_state(state);
            GTK.gtk_gesture_get_point(gesture, GTK.gtk_gesture_get_last_updated_sequence(gesture), x, y);
            Control control = Control.getControl(user_data);
            control.sendGestureEvent(state[0], 4, (int)x[0], (int)y[0], 0.0);
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, dir);
            }
            if (this.fixedHandle != 0L) {
                GTK.gtk_widget_set_direction(this.fixedHandle, dir);
            }
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.setOrientation(false);
        this.style &= 0xF7FFFFFF;
        this.checkMirrored();
    }

    public boolean setParent(Composite parent) {
        int height;
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        GTK.gtk_widget_realize(parent.handle);
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((parent.style & 0x8000000) != 0) {
            x = parent.getClientWidth() - width - x;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        Menu[] menus = oldShell.findMenus(this);
        if (oldShell != newShell || oldDecorations != newDecorations) {
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            newDecorations.fixAccelGroup();
            oldDecorations.fixAccelGroup();
        }
        long newParent = parent.parentingHandle();
        Control.gtk_widget_reparent(this, newParent);
        OS.swt_fixed_move(newParent, topHandle, x, y);
        this.resizeHandle(width, height);
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(topHandle, requisition);
        allocation.x = x;
        allocation.y = y;
        allocation.width = width;
        allocation.height = height;
        if (GTK.GTK4) {
            GTK.gtk_widget_size_allocate(topHandle, allocation, -1);
        } else {
            GTK.gtk_widget_size_allocate(topHandle, allocation);
        }
        this.parent = parent;
        this.setZOrder(null, false, true);
        this.reskin(1);
        return true;
    }

    void setParentBackground() {
        this.setBackgroundGdkRGBA(this.handle, null);
        if (this.fixedHandle != 0L) {
            this.setBackgroundGdkRGBA(this.fixedHandle, null);
        }
    }

    void setParentGdkResource(Control child) {
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                if (GTK.GTK4) {
                    if (this.redrawSurface != 0L) {
                        GDK.gdk_surface_hide(this.redrawSurface);
                        GDK.gdk_surface_destroy(this.redrawSurface);
                        this.redrawSurface = 0L;
                    }
                } else if (this.redrawWindow != 0L) {
                    long window = this.paintWindow();
                    GDK.gdk_window_hide(this.redrawWindow);
                    GDK.gdk_window_destroy(this.redrawWindow);
                    GDK.gdk_window_set_events(window, GTK.gtk_widget_get_events(this.paintHandle()));
                    this.redrawWindow = 0L;
                }
            }
        } else if (this.drawCount++ == 0 && GTK.gtk_widget_get_realized(this.handle)) {
            Rectangle bounds = this.getBoundsInPixels();
            if (GTK.GTK4) {
                this.redrawSurface = GDK.gdk_surface_new_toplevel(GDK.gdk_display_get_default());
            } else {
                long window = this.paintWindow();
                GdkWindowAttr attributes = new GdkWindowAttr();
                attributes.width = bounds.width;
                attributes.height = bounds.height;
                attributes.event_mask = 2;
                attributes.window_type = 2;
                this.redrawWindow = GDK.gdk_window_new(window, attributes, 0);
                if (this.redrawWindow != 0L) {
                    int mouseMask = 13308;
                    GDK.gdk_window_set_events(window, GDK.gdk_window_get_events(window) & ~mouseMask);
                    if (GTK.GTK_VERSION < OS.VERSION(3, 22, 0)) {
                        GDK.gdk_window_set_background_pattern(this.redrawWindow, 0L);
                    }
                    GDK.gdk_window_show(this.redrawWindow);
                }
            }
        }
    }

    @Override
    boolean setTabItemFocus(boolean next) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int textDirection) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.setToolTipText(this._getShell(), string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        if (this.display.currentControl == this) {
            shell.setToolTipText(shell.handle, this.eventHandle(), newString);
        }
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == visible) {
            return;
        }
        long topHandle = this.topHandle();
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                GTK.gtk_widget_show(topHandle);
            }
        } else {
            Control control = null;
            boolean fixFocus = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (fixFocus) {
                GTK.gtk_widget_set_can_focus(topHandle, false);
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                GTK.gtk_widget_set_can_focus(topHandle, true);
            }
            GTK.gtk_widget_hide(topHandle);
            if (this.isDisposed()) {
                return;
            }
            if (GTK.GTK4) {
                if (this.enableSurface != 0L) {
                    GDK.gdk_surface_hide(this.enableSurface);
                }
            } else if (this.enableWindow != 0L) {
                GDK.gdk_window_hide(this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        this.setZOrder(sibling, above, fixRelations, true);
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations, boolean fixChildren) {
        long siblingHandle;
        int index;
        int siblingIndex = 0;
        int oldNextIndex = -1;
        Control[] children = null;
        if (fixRelations) {
            children = this.parent._getChildren();
            for (index = 0; index < children.length && children[index] != this; ++index) {
            }
            if (sibling != null) {
                while (siblingIndex < children.length && children[siblingIndex] != sibling) {
                    ++siblingIndex;
                }
            }
            this.removeRelation();
            if (index + 1 < children.length) {
                oldNextIndex = index + 1;
                children[oldNextIndex].removeRelation();
            }
            if (sibling != null) {
                if (above) {
                    sibling.removeRelation();
                } else if (siblingIndex + 1 < children.length) {
                    children[siblingIndex + 1].removeRelation();
                }
            }
        }
        long topHandle = this.topHandle();
        long l = siblingHandle = sibling != null ? sibling.topHandle() : 0L;
        if (GTK.GTK4) {
            long surface = this.gtk_widget_get_surface(topHandle);
            if (surface != 0L) {
                long redrawSurface;
                long siblingSurface = 0L;
                if (sibling != null) {
                    siblingSurface = above && sibling.enableSurface != 0L ? this.enableSurface : GTK.gtk_native_get_surface(GTK.gtk_widget_get_native(siblingHandle));
                }
                long l2 = redrawSurface = fixChildren ? this.parent.redrawSurface : 0L;
                if (!OS.isX11() || siblingSurface == 0L && (!above || redrawSurface == 0L)) {
                    if (above) {
                        int width = GDK.gdk_surface_get_width(surface);
                        int height = GDK.gdk_surface_get_height(surface);
                        long layout = GDK.gdk_toplevel_layout_new(width, height);
                        GDK.gdk_toplevel_present(surface, width, height, layout);
                        if (redrawSurface != 0L) {
                            GDK.gdk_toplevel_present(redrawSurface, width, height, layout);
                        }
                        if (this.enableSurface != 0L) {
                            GDK.gdk_toplevel_present(this.enableSurface, width, height, layout);
                        }
                    } else {
                        if (this.enableSurface != 0L) {
                            GDK.gdk_toplevel_lower(this.enableSurface);
                        }
                        GDK.gdk_toplevel_lower(surface);
                    }
                }
            }
        } else {
            long window = this.gtk_widget_get_window(topHandle);
            if (window != 0L) {
                long redrawWindow;
                long siblingWindow = 0L;
                if (sibling != null) {
                    siblingWindow = above && sibling.enableWindow != 0L ? this.enableWindow : GTK.gtk_widget_get_window(siblingHandle);
                }
                long l3 = redrawWindow = fixChildren ? this.parent.redrawWindow : 0L;
                if (!OS.isX11() || siblingWindow == 0L && (!above || redrawWindow == 0L)) {
                    if (above) {
                        GDK.gdk_window_raise(window);
                        if (redrawWindow != 0L) {
                            GDK.gdk_window_raise(redrawWindow);
                        }
                        if (this.enableWindow != 0L) {
                            GDK.gdk_window_raise(this.enableWindow);
                        }
                    } else {
                        if (this.enableWindow != 0L) {
                            GDK.gdk_window_lower(this.enableWindow);
                        }
                        GDK.gdk_window_lower(window);
                    }
                } else {
                    long siblingW = siblingWindow != 0L ? siblingWindow : redrawWindow;
                    boolean stack_mode = above;
                    if (redrawWindow != 0L && siblingWindow == 0L) {
                        stack_mode = false;
                    }
                    this.restackWindow(window, siblingW, stack_mode);
                    if (this.enableWindow != 0L) {
                        this.restackWindow(this.enableWindow, window, true);
                    }
                }
            }
        }
        if (fixChildren) {
            if (above) {
                this.parent.moveAbove(topHandle, siblingHandle);
            } else {
                this.parent.moveBelow(topHandle, siblingHandle);
            }
        }
        if (!above && fixChildren) {
            this.parent.fixZOrder();
        }
        if (fixRelations) {
            index = sibling != null ? (above ? siblingIndex - (index < siblingIndex ? 1 : 0) : siblingIndex + (siblingIndex < index ? 1 : 0)) : (above ? 0 : children.length - 1);
            children = this.parent._getChildren();
            if (0 < index) {
                children[index - 1].addRelation(this);
            }
            if (index + 1 < children.length) {
                this.addRelation(children[index + 1]);
            }
            if (oldNextIndex != -1) {
                if (oldNextIndex <= index) {
                    --oldNextIndex;
                }
                if (0 < oldNextIndex && oldNextIndex != index && oldNextIndex != index + 1) {
                    children[oldNextIndex - 1].addRelation(children[oldNextIndex]);
                }
            }
        }
    }

    void setWidgetBackground() {
        GdkRGBA rgba;
        GdkRGBA gdkRGBA = rgba = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
        if (this.fixedHandle != 0L) {
            this.setBackgroundGdkRGBA(this.fixedHandle, rgba);
        }
        this.setBackgroundGdkRGBA(this.handle, rgba);
    }

    boolean showMenu(int x, int y) {
        return this.showMenu(x, y, 0);
    }

    boolean showMenu(int x, int y, int detail) {
        Event event = new Event();
        Rectangle eventRect = new Rectangle(x, y, 0, 0);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        event.detail = detail;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
            if (rect.x != x || rect.y != y) {
                this.menu.setLocationInPixels(rect.x, rect.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        long topHandle = this.topHandle();
        long parentHandle = this.parent.parentingHandle();
        this.parent.setParentGdkResource(this);
        if (GTK.GTK4) {
            OS.swt_fixed_add(parentHandle, topHandle);
        } else {
            GTK.gtk_container_add(parentHandle, topHandle);
        }
        if (this.handle != 0L && this.handle != topHandle) {
            GTK.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0L) {
            GTK.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        for (int gap = length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < length; ++i) {
                for (int j = i - gap; j >= 0; j -= gap) {
                    if (items[j] > items[j + gap]) continue;
                    int swap = items[j];
                    items[j] = items[j + gap];
                    items[j + gap] = swap;
                }
            }
        }
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    if (character == '\u0000' || (stateMask & 0x50000) != 65536) break;
                    traversal = 128;
                    doit = true;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int keyval, long event) {
        Decorations shell;
        long key = GDK.gdk_keyval_to_unicode(keyval);
        int[] state = new int[1];
        if (GTK.GTK4) {
            state[0] = GDK.gdk_event_get_modifier_state(event);
        } else {
            GDK.gdk_event_get_state(event, state);
        }
        if (key < 32L) {
            return false;
        }
        if (state[0] == 0) {
            int code = this.traversalCode(keyval, event);
            if ((code & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell2 = this._getShell();
            int mask = 13;
            if (GTK.GTK4 ? state[0] != 8 : (state[0] & mask) != GTK.gtk_window_get_mnemonic_modifier(shell2.shellHandle)) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            Event javaEvent = new Event();
            javaEvent.detail = 128;
            if (this.setKeyState(javaEvent, event)) {
                return this.translateMnemonic(javaEvent, null) || shell.translateMnemonic(javaEvent, this);
            }
        }
        return false;
    }

    boolean translateTraversal(long event) {
        int detail = 0;
        int[] eventKeyval = new int[1];
        int[] eventState = new int[1];
        if (GTK.GTK4) {
            eventKeyval[0] = GDK.gdk_key_event_get_keyval(event);
            eventState[0] = GDK.gdk_event_get_modifier_state(event);
        } else {
            GDK.gdk_event_get_keyval(event, eventKeyval);
            GDK.gdk_event_get_state(event, eventState);
        }
        int key = eventKeyval[0];
        int code = this.traversalCode(key, event);
        boolean all = false;
        switch (key) {
            case 65307: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean next = (eventState[0] & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next;
                boolean bl = next = key == 65364 || key == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (key == 65361 || key == 65363)) {
                    next = !next;
                }
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((eventState[0] & 4) == 0) {
                    return false;
                }
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event javaEvent = new Event();
        javaEvent.doit = (code & detail) != 0;
        javaEvent.detail = detail;
        javaEvent.time = GDK.gdk_event_get_time(event);
        if (!this.setKeyState(javaEvent, event)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(javaEvent)) {
                return true;
            }
            if (!javaEvent.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, long event) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        int offset;
        int index;
        Control root = this.computeTabRoot();
        Widget group = this.computeTabGroup();
        Widget[] list = root.computeTabList();
        int length = list.length;
        for (index = 0; index < length && list[index] != group; ++index) {
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int n = offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Widget widget = list[index];
            if (widget.isDisposed() || !widget.setTabGroupFocus(next)) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus(next);
    }

    boolean traverseItem(boolean next) {
        int offset;
        int index;
        Control[] children = this.parent._getChildren();
        int length = children.length;
        for (index = 0; index < length && children[index] != this; ++index) {
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int n = offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean all, boolean flush) {
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long window = this.paintWindow();
        if (flush) {
            this.display.flushExposes(window, all);
        }
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x8000;
        this.checkBackground();
        if (oldState != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean all) {
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                boolean draw;
                if ((this.state & 0x40) != 0) break;
                Control control = this.findBackgroundControl();
                boolean bl = draw = control != null && control.backgroundImage != null;
                if (!draw && (this.state & 2) != 0) {
                    boolean bl2 = draw = (this.state & 0x2000) == 0;
                }
                if (!draw) break;
                long cairo = arg0;
                GdkRectangle rect = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(cairo, rect);
                if (control == null) {
                    control = this;
                }
                if (GTK.GTK4) {
                    long gdkResource = GTK.gtk_native_get_surface(GTK.gtk_widget_get_native(handle));
                    this.drawBackground(control, gdkResource, cairo, rect.x, rect.y, rect.width, rect.height);
                    break;
                }
                long gdkResource = GTK.gtk_widget_get_window(handle);
                if (gdkResource != 0L) {
                    this.drawBackground(control, gdkResource, 0L, rect.x, rect.y, rect.width, rect.height);
                    break;
                }
                this.drawBackground(control, 0L, cairo, rect.x, rect.y, rect.width, rect.height);
                break;
            }
            case 18: {
                if (this.paintHandle() != handle || !this.drawRegion) break;
                return this.gtk_draw(handle, arg0);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    Point getWindowOrigin() {
        int[] x = new int[1];
        int[] y = new int[1];
        long window = this.eventWindow();
        GDK.gdk_window_get_origin(window, x, y);
        return new Point(x[0], y[0]);
    }

    Point getSurfaceOrigin() {
        int[] x = new int[1];
        int[] y = new int[1];
        long surface = this.eventSurface();
        GDK.gdk_surface_get_origin(surface, x, y);
        return new Point(x[0], y[0]);
    }
}

