/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DvbTaxVersion
implements Comparable<DvbTaxVersion> {
    private List<Integer> versions = new LinkedList<Integer>();
    private String filenameWithoutVersion;
    private Integer year = null;
    private boolean isSnapshot = false;
    private boolean isLatestLocalBuild = false;
    private static final Pattern PATTERN = Pattern.compile("([^-]+)[-]{1,1}(?:([0-9]{4})-)?([0-9]+)[.]?([0-9]+)[.]?([0-9]+)[^0-9]*|([^0-9]+)(-{1,1}[^0-9]*)");
    private static final String LATESTLOCALBUILD = "localbuild";

    public DvbTaxVersion(String filename) {
        this.versions = this.parseVersion(filename);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Integer element : this.versions) {
            sb.append(element).append(".");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(DvbTaxVersion version) {
        int res;
        if (this.year != null && version.year != null && (res = this.year.compareTo(version.year)) != 0) {
            return res;
        }
        if (this.versions.isEmpty() && !this.isLatestLocalBuild && !version.isLatestLocalBuild) {
            return -1;
        }
        if (version.versions.isEmpty() && !version.isLatestLocalBuild) {
            return 1;
        }
        Iterator<Integer> itThis = this.versions.iterator();
        Iterator<Integer> itThat = version.versions.iterator();
        while (itThis.hasNext() && itThat.hasNext()) {
            Integer sThat;
            Integer sThis = itThis.next();
            int result = sThis.compareTo(sThat = itThat.next());
            if (result == 0) continue;
            return result;
        }
        if (this.isSnapshot && !version.isSnapshot) {
            return -1;
        }
        if (!this.isSnapshot && version.isSnapshot) {
            return 1;
        }
        if (this.isLatestLocalBuild && !version.isLatestLocalBuild()) {
            return 1;
        }
        if (!this.isLatestLocalBuild && version.isLatestLocalBuild()) {
            return -1;
        }
        return 0;
    }

    public List<Integer> parseVersion(String filename) {
        Matcher matcher = PATTERN.matcher(filename);
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (matcher.matches()) {
            int groups = matcher.groupCount();
            this.filenameWithoutVersion = matcher.group(1);
            String yearStr = matcher.group(2);
            if (yearStr != null) {
                this.year = Integer.valueOf(yearStr);
            }
            this.isLatestLocalBuild = filename.toLowerCase().contains(LATESTLOCALBUILD);
            if (!this.isLatestLocalBuild) {
                for (int i = 3; i <= groups - 2; ++i) {
                    String group = matcher.group(i);
                    if (group == null) continue;
                    Integer version = Integer.valueOf(matcher.group(i));
                    result.add(version);
                }
                this.isSnapshot = filename.endsWith("-SNAPSHOT");
            } else {
                this.filenameWithoutVersion = matcher.group(6);
            }
        }
        return result;
    }

    public static boolean isValidFilename(String filename) {
        Matcher matcher = PATTERN.matcher(filename);
        return matcher.matches();
    }

    public String getFilenameWithoutVersion() {
        return this.filenameWithoutVersion;
    }

    public Integer getYear() {
        return this.year;
    }

    public String getFileVersion() {
        StringBuilder fileVersion = new StringBuilder();
        if (this.year != null) {
            fileVersion.append(this.year).append("-");
        }
        for (int i = 0; i < this.versions.size(); ++i) {
            fileVersion.append(this.versions.get(i).toString());
            if (i == this.versions.size() - 1) continue;
            fileVersion.append(".");
        }
        return fileVersion.toString();
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isLatestLocalBuild() {
        return this.isLatestLocalBuild;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DvbTaxVersion rhs = (DvbTaxVersion)obj;
        return new EqualsBuilder().append(this.versions, rhs.versions).append(this.isSnapshot, rhs.isSnapshot).append(this.isLatestLocalBuild, rhs.isLatestLocalBuild).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.versions).append(this.isSnapshot).append(this.isLatestLocalBuild).toHashCode();
    }
}

