/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

public class PersistenceKeyTemplateDTO {
    private static final String MEHRFACHVORKOMMEN = "#";
    private static final String EINZELVORKOMMEN = "?";
    private Integer dokument;
    private Integer ziffer;
    private Integer zelle;
    private String lnDokumentTemplate;
    private String lnZelleTemplate;
    private Integer lnDokument;
    private Integer lnZelle;

    public PersistenceKeyTemplateDTO(String persistenceKey) {
        String[] keyParts = persistenceKey.split("\\.");
        if (keyParts.length == 5) {
            this.setDokument(Integer.valueOf(keyParts[0]));
            this.setLnDokumentTemplate(keyParts[1]);
            if (!this.getLnDokumentTemplate().equals(MEHRFACHVORKOMMEN) && !this.getLnDokumentTemplate().equals(EINZELVORKOMMEN)) {
                this.setLnDokument(Integer.valueOf(this.getLnDokumentTemplate()));
            }
            this.setZiffer(Integer.valueOf(keyParts[2]));
            this.setZelle(Integer.valueOf(keyParts[3]));
            this.setLnZelleTemplate(keyParts[4]);
            if (!this.getLnZelleTemplate().equals(MEHRFACHVORKOMMEN) && !this.getLnZelleTemplate().equals(EINZELVORKOMMEN)) {
                this.setLnZelle(Integer.valueOf(this.getLnZelleTemplate()));
            }
        } else {
            throw new IllegalArgumentException("Invalid PersistenceKey: " + persistenceKey);
        }
    }

    public String getPersistenceKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDokument()).append(".");
        sb.append(this.getLnDokument()).append(".");
        sb.append(this.getZiffer()).append(".");
        sb.append(this.getZelle()).append(".");
        sb.append(this.getLnZelle());
        return sb.toString();
    }

    public boolean hasDokumentMehrfachvorkommen() {
        return MEHRFACHVORKOMMEN.equals(this.getLnDokumentTemplate());
    }

    public boolean hasZelleMehrfachvorkommen() {
        return MEHRFACHVORKOMMEN.equals(this.getLnZelleTemplate());
    }

    public Integer getDokument() {
        return this.dokument;
    }

    public void setDokument(Integer dokument) {
        this.dokument = dokument;
    }

    public Integer getZiffer() {
        return this.ziffer;
    }

    public void setZiffer(Integer ziffer) {
        this.ziffer = ziffer;
    }

    public Integer getZelle() {
        return this.zelle;
    }

    public void setZelle(Integer zelle) {
        this.zelle = zelle;
    }

    public String getLnDokumentTemplate() {
        return this.lnDokumentTemplate;
    }

    public void setLnDokumentTemplate(String lnDokumentTemplate) {
        this.lnDokumentTemplate = lnDokumentTemplate;
    }

    public String getLnZelleTemplate() {
        return this.lnZelleTemplate;
    }

    public void setLnZelleTemplate(String lnZelleTemplate) {
        this.lnZelleTemplate = lnZelleTemplate;
    }

    public Integer getLnDokument() {
        return this.lnDokument;
    }

    public void setLnDokument(Integer lnDokument) {
        this.lnDokument = lnDokument;
    }

    public Integer getLnZelle() {
        return this.lnZelle;
    }

    public void setLnZelle(Integer lnZelle) {
        this.lnZelle = lnZelle;
    }
}

