/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import java.text.Collator;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardTableRowComparator
implements Comparator<WizardDisplayInfoDTO.RowItemDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(WizardTableRowComparator.class);
    private boolean asc = true;
    private int column = 0;
    private @NonNull AbstractConverter.ConverterContext ctx;
    private Collator collator = null;

    public WizardTableRowComparator(int column, boolean asc, @NonNull AbstractConverter.ConverterContext ctx) {
        this.column = column;
        this.asc = asc;
        this.ctx = ctx;
        try {
            this.collator = Collator.getInstance(ctx.getLocalizationHelper().getCurrentLocale());
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compare(WizardDisplayInfoDTO.RowItemDTO row1, WizardDisplayInfoDTO.RowItemDTO row2) {
        int ret = this.compareAsc(row1, row2);
        return this.asc ? ret : -1 * ret;
    }

    private int compareAsc(WizardDisplayInfoDTO.RowItemDTO row1, WizardDisplayInfoDTO.RowItemDTO row2) {
        Comparable value1 = this.getComparableValue(row1, this.column);
        Comparable value2 = this.getComparableValue(row2, this.column);
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof String && value2 instanceof String) {
            return this.compareAsc((String)((Object)value1), (String)((Object)value2));
        }
        return this.compareAsc(value1, value2);
    }

    private Comparable getComparableValue(WizardDisplayInfoDTO.RowItemDTO row, int col) {
        WizardDisplayInfoDTO.AbstractItemDTO item = row.getCols().get(col);
        if (item instanceof WizardDisplayInfoDTO.ItemItemDTO) {
            return this.getItemValue((WizardDisplayInfoDTO.ItemItemDTO)item);
        }
        if (item instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)item;
            try {
                Object[] args = WizardLabelAddOnHelper.getReplacements(labelItemDTO.getLabelAddOns(), this.ctx);
                return this.ctx.getLocalizationHelper().translate(labelItemDTO.getName().toString(), args);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                LOG.warn("translation failed", (Throwable)e);
                return "";
            }
        }
        if (item instanceof WizardDisplayInfoDTO.StateItemDTO) {
            return Integer.valueOf(((WizardDisplayInfoDTO.StateItemDTO)item).getState());
        }
        return null;
    }

    private Comparable getItemValue(WizardDisplayInfoDTO.ItemItemDTO item) {
        Object value = item.getValue();
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        AbstractConverter<?> conv = item.getRendererAndInputValidator();
        if (conv == null) {
            return value.toString();
        }
        return conv.getRenderedValue(value, item.getReadonly(), item.getOptionItems(), this.ctx);
    }

    private int compareAsc(String value1, String value2) {
        return this.collator.compare(value1, value2);
    }

    private int compareAsc(Comparable value1, Comparable value2) {
        if (value1.getClass().equals(value2.getClass())) {
            return value1.compareTo(value2);
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            Double d1 = ((Number)((Object)value1)).doubleValue();
            Double d2 = ((Number)((Object)value2)).doubleValue();
            return d1.compareTo(d2);
        }
        return this.compareAsc(value1.toString(), value2.toString());
    }
}

