/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TaxFileAttachment
implements Comparable<TaxFileAttachment> {
    private final String fileName;
    private String comment;
    private final long size;
    private final TaxFile taxFile;

    protected TaxFileAttachment(String fileName, String comment, long size, TaxFile taxFile) {
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        if (taxFile == null) {
            throw new NullPointerException("taxFile may not be null");
        }
        if (comment == null) {
            comment = "";
        }
        this.comment = comment;
        this.fileName = fileName;
        this.size = size;
        this.taxFile = taxFile;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) throws IOException {
        this.taxFile.setComment(this.fileName, comment);
        this.comment = comment;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public int compareTo(TaxFileAttachment other) {
        return this.fileName.compareToIgnoreCase(other.fileName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TaxFileAttachment rhs = (TaxFileAttachment)obj;
        return new EqualsBuilder().append((Object)this.fileName, (Object)rhs.fileName).append((Object)this.comment, (Object)rhs.comment).append(this.size, rhs.size).append((Object)this.taxFile, (Object)rhs.taxFile).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fileName).append((Object)this.comment).append(this.size).append((Object)this.taxFile).toHashCode();
    }
}

