/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfValue;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.Resolver;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DataModelDelegateResolver
implements Resolver {
    private final @NonNull String scheme;
    private final @NonNull DataModelResolver delegate;

    protected DataModelDelegateResolver(@NonNull String scheme, @NonNull DataModelResolver delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.scheme = Objects.requireNonNull(scheme);
    }

    protected @NonNull DataModelResolver getDelegate() {
        return this.delegate;
    }

    @Override
    public @NonNull String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean supports(@NonNull PdfKey pdfKey) {
        return pdfKey.getScheme().equals(this.scheme);
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.scheme).toString();
    }

    @Override
    public @NonNull Set<URI> getFonts() {
        return this.getDelegate().getFonts();
    }

    @Override
    public boolean validate(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull RunContext ctx) {
        return this.dataModelValidate(pdfKey, tableRow, ctx);
    }

    protected boolean dataModelValidate(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull RunContext ctx) {
        return this.getDelegate().validate(pdfKey.withScheme("model"), tableRow, ctx);
    }

    @Override
    public @Nullable LMK tableLMK(@NonNull PdfKey pdfKey, @NonNull RunContext ctx) {
        return this.dataModelTableLMK(pdfKey, ctx);
    }

    protected @Nullable LMK dataModelTableLMK(@NonNull PdfKey pdfKey, @NonNull RunContext ctx) {
        return this.getDelegate().tableLMK(pdfKey.withScheme("model"), ctx);
    }

    @Override
    public @Nullable Object resolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        return this.dataModelResolve(pdfKey, tableRow, page, ctx);
    }

    protected @Nullable Object dataModelResolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        return this.getDelegate().resolve(pdfKey.withScheme("model"), tableRow, page, ctx);
    }

    @Override
    public @Nullable String formatValue(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfValue resolvedValue, @NonNull RunContext ctx) {
        return this.dataModelFormatValue(pdfKey, tableRow, resolvedValue, ctx);
    }

    protected @Nullable String dataModelFormatValue(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfValue resolvedValue, @NonNull RunContext ctx) {
        return this.getDelegate().formatValue(pdfKey.withScheme("model"), tableRow, resolvedValue, ctx);
    }
}

