/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.pdf.PdfTemplate;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPrinter
extends ExpertItemPrinter<ExpertDisplayInfoDTO.TextItemDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(TextPrinter.class);
    private static final String DATE_FORMAT = "dd.MM.yyyy";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_TIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private static final String PROPERTY_SEPARATOR = "@";
    private static final String[] STANDARD_FILTERING_KEYS = new String[]{"formpage", "formpages", "extrapage", "docpage", "version"};
    private final boolean filteringEnabled;
    private ExpertDisplayInfoDTO.TextItemDTO item;
    private String[] searchList = null;
    private String[] replacementList = null;

    public TextPrinter(boolean filteringEnabled) {
        this.filteringEnabled = filteringEnabled;
    }

    @Override
    protected void initalize(@NonNull ExpertDisplayInfoDTO.TextItemDTO item) {
        this.item = item;
        if (!this.filteringEnabled || this.searchList != null) {
            return;
        }
        Map<String, Object> properties = this.getDocumentContext().getProperties();
        ArrayList<CallSite> searchList = new ArrayList<CallSite>();
        ArrayList<String> replacementList = new ArrayList<String>();
        for (String standardFilteringKey : STANDARD_FILTERING_KEYS) {
            searchList.add((CallSite)((Object)(PROPERTY_SEPARATOR + standardFilteringKey + PROPERTY_SEPARATOR)));
            replacementList.add(null);
        }
        for (Map.Entry entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            searchList.add((CallSite)((Object)(PROPERTY_SEPARATOR + (String)entry.getKey() + PROPERTY_SEPARATOR)));
            replacementList.add((String)value);
        }
        assert (searchList.size() == replacementList.size());
        int effectiveSize = searchList.size();
        this.searchList = new String[effectiveSize];
        searchList.toArray(this.searchList);
        this.replacementList = new String[effectiveSize];
        replacementList.toArray(this.replacementList);
    }

    @Override
    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        if (this.item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            ExpertDisplayInfoDTO.ValueItemDTO valueItem = (ExpertDisplayInfoDTO.ValueItemDTO)this.item;
            if (valueItem.getModelItem() != null && valueItem.getModelItem().getState() == 12) {
                return;
            }
            Map<String, ExpertDisplayInfoDTO.ValuePositionDTO> pos = valueItem.getValuePositions();
            if (pos != null && !pos.isEmpty()) {
                this.printValuePosition(valueItem, xOffset, yOffset);
                return;
            }
        }
        float llx = this.calcLowerLeftX(this.item, xOffset);
        float lly = this.calcLowerLeftY(this.item, yOffset);
        float urx = this.calcUpperRightX(this.item, xOffset);
        float ury = this.calcUpperRightY(this.item, yOffset);
        if (this.item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            if (this.item.getAlignment() == 0) {
                llx += this.getDocumentContext().getValuePaddingX();
            } else if (this.item.getAlignment() == 2) {
                urx -= this.getDocumentContext().getValuePaddingX();
            }
            int type = ((ExpertDisplayInfoDTO.ValueItemDTO)this.item).getType();
            if (type != 1 && type != 3) {
                lly -= this.getDocumentContext().getValuePaddingY();
                ury -= this.getDocumentContext().getValuePaddingY();
            }
        }
        String text = this.getText(this.item);
        if (this.filteringEnabled && (text = this.doReplacements(text)).contains("@docpages@")) {
            PdfTemplate templ = this.getDirectContent().createTemplate(urx - llx, ury - lly);
            this.getDirectContent().addTemplate(templ, llx, lly);
            this.getDocumentContext().addTemplate(new Template(templ, text, this.item.getFont(), this.item.getAlignment()));
            return;
        }
        this.printText(text, llx, lly, urx, ury, this.item.getFont(), this.item.getAlignment());
    }

    private String doReplacements(String text) {
        assert (this.filteringEnabled && this.searchList != null && this.replacementList != null);
        if (!text.contains(PROPERTY_SEPARATOR)) {
            return text;
        }
        DocumentContext ctx = this.getDocumentContext();
        this.replacementList[0] = String.valueOf(ctx.getFormPage());
        this.replacementList[1] = String.valueOf(ctx.getFormPages());
        this.replacementList[2] = String.valueOf(ctx.getFormPage() - 1);
        this.replacementList[3] = String.valueOf(ctx.getWriter().getPageNumber());
        this.replacementList[4] = FormRendererUtil.getApplicationVersion();
        text = StringUtils.replaceEachRepeatedly((String)text, (String[])this.searchList, (String[])this.replacementList);
        long timestamp = ctx.getTimestamp();
        text = TextPrinter.replaceDates(timestamp, text, "@date@", DATE_FORMAT);
        text = TextPrinter.replaceDates(timestamp, text, "@time@", TIME_FORMAT);
        text = TextPrinter.replaceDates(timestamp, text, "@datetime@", DATE_TIME_FORMAT);
        return text;
    }

    private static String replaceDates(long timestamp, String text, String toReplace, String defaultFormat) {
        int pos = text.indexOf(toReplace);
        while (pos > -1) {
            int formatEnd;
            int formatStart;
            String format = defaultFormat;
            int end = pos + toReplace.length();
            if (end < text.length() && text.charAt(end) == '#' && (formatStart = end + 1) < text.length() && (formatEnd = text.indexOf(35, formatStart)) > -1) {
                format = text.substring(formatStart, formatEnd);
                end = formatEnd + 1;
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setTimeZone(ApplicationConfig.TIMEZONE);
                StringBuilder sb = new StringBuilder(text);
                sb.replace(pos, end, sdf.format(timestamp));
                text = sb.toString();
            }
            catch (Exception e) {
                LOG.warn("date formatting failed", (Throwable)e);
            }
            pos = text.indexOf(toReplace);
        }
        return text;
    }
}

